<?php $__env->startSection('title'); ?> Driver List <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?> 
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="product-status mg-b-30">
    <div class="container-fluid">
        <div class="row dataList">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align: left;">
                <div class="product-status-wrap">
                    <h4 class="heading_h4" style="margin-left: 10px;"><i class="fas fa-hotel"></i> Driver List</h4>
                
                    <!--<div class="row dataRow">-->
                    <!--    <div class="col-4">-->
                    <!--        <select class="form-control">-->
                    <!--            <option>The current Orders</option>-->
                    <!--            <option>Completed Orders</option>-->
                    <!--            <option>All</option>-->
                    <!--        </select>-->
                    <!--    </div>-->
                    <!--    <div class="col cp_iptxt">-->
                    <!--        <input type="search" style="width: 14em;" class="cp_iptxt" placeholder="Search" name="search" id="search" >-->
                    <!--        <i class="fas fa-search" style="left: 15px"></i>-->
                    <!--        <button class="btn btn-primary" style="padding: 0.5rem; font-size: small;">Search</button>-->
                    <!--        <button class="btn btn-primary" style="padding: 0.5rem; font-size: small; margin-left: 10px;" data-bs-toggle="modal" data-bs-target="#filterModal">Filter</button>-->
                    <!--    </div>-->
                    <!--</div>-->

                    <table id="driverListTable">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Mobile</th>
                            <th>City</th>
                            <th>Visa Type</th>
                            <th>Vehicle Availability</th>
                            <th>Vehicle Model</th>
                            <th>Transporter Type</th>
                            <th>Update Date Time</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($driver->driver_first_name); ?> <?php echo e($driver->driver_last_name); ?></td>
                                <td><?php echo e($driver->email); ?></td>
                                <td><?php echo e($driver->driver_phone); ?></td>
                                <td><?php echo e($driver->driver_city); ?></td>
                                <td><?php echo e($driver->driver_visa_status); ?></td>
                                <td><?php if($driver->driver_vehicle_owner): ?> Yes <?php else: ?> No <?php endif; ?></td>
                                <td><?php echo e($driver->driver_vehicle_num); ?></td>
                                <td><?php echo e($driver->driver_transport_type); ?></td></td>
                                <td><?php echo e($driver->created_at); ?></td></td>
                                <td>
                                    <a href="<?php echo e(route('admin.drivers.edit', $driver)); ?>" class="orders icons" ><i class="fas fa-edit"></i></a>
                                    <a href="<?php echo e(route('admin.drivers.password.edit', $driver)); ?>" class="orders icons" ><i class="fas fa-key"></i></a>
                                    <a onclick="event.preventDefault(); swalDelete('#delete-form-<?php echo e($driver->driver_id); ?>')" class="orders icons"><i class="fas fa-trash-alt"></i></a>
                                    <form id="delete-form-<?php echo e($driver->driver_id); ?>" action="<?php echo e(route('admin.drivers.delete', $driver)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
    
<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready( function () {
    $('#driverListTable').DataTable();
} );

function swalDelete(form_id) {
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert driver!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, Delete driver!',
      customClass: {
        confirmButton: 'btn btn-primary',
        cancelButton: 'btn btn-outline-danger ms-1'
      },
      buttonsStyling: false
    }).then(function(result) {
      if (result.value) {
        $(form_id).submit();

        Swal.fire({
          icon: 'success',
          title: 'Deleted!',
          text: 'Driver has been deleted.',
          customClass: {
            confirmButton: 'btn btn-success'
          }
        });

      } else if (result.dismiss === Swal.DismissReason.cancel) {
        Swal.fire({
          title: 'Cancelled',
          text: 'Cancelled Delete :)',
          icon: 'error',
          customClass: {
            confirmButton: 'btn btn-success'
          }
        });
      }
    });
};
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/trustmoversfreight.com/resources/views/admin/driver_list.blade.php ENDPATH**/ ?>