
<?php $__env->startSection('title'); ?> Driver List <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('/img/trust.jpg')); ?>">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(asset('/css1/metisMenu/metisMenu.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/css1/metisMenu/metisMenu-vertical.css')); ?>">

<link href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,700,900" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(asset('/css1/bootstrap.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/css1/meanmenu.min.css')); ?>">
<link href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(asset('/css1/main.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/css1/style.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/css/responsive.css')); ?>">

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="<?php echo e(asset('/js1/jquery.meanmenu.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="single-product-tab-area">
    <div class="single-pro-review-area">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="review-tab-pro-inner">
                        <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <?php endif; ?>
                        <div class="error_msg">
                            <p style="text-align: center; color: red;" id="errMsg"></p>
                        </div>
                        <div id="myTabContent" class="tab-content custom-product-edit">
                            <form action="<?php echo e(route('admin.drivers.update', $driver)); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo e(csrf_field()); ?>

                                <div class="product-tab-list tab-pane fade active in" id="description">
                                    <div class="row">
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 m-5">
                                            <div class="review-content-section">
                                                <fieldset>
                                                    <legend><i class="fas fa-user-edit"></i> Edit Driver</legend>
                                                    <div class="form-div">
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label for="fName">First Name</label>
                                                            <input type="text" class="form-control" placeholder="First Name*" name="firstname" id="fName" value="<?php echo e($driver->driver_first_name); ?>" required>
                                                            <label class="error text-danger" hidden="" id="fNameError">First Name is required </label>
                                                        </div>
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label for="lName">Last Name</label>
                                                            <input type="text" class="form-control" placeholder="Last Name*" name="lastname" id="lName" value="<?php echo e($driver->driver_last_name); ?>" required>
                                                            <label class="error text-danger" hidden="" id="lNameError">Last Name is required </label>
                                                        </div>
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label for="uMail">Email</label>
                                                            <input type="Email" class="form-control" placeholder="Email" name="email" id="uMail" value="<?php echo e($driver->email); ?>">
                                                            <label class="error text-danger" hidden="" id="eMailError"> Email is invalid </label>
                                                        </div>
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label for="uMobile">Mobile</label>
                                                            <input type="tel" class="form-control" placeholder="Mobile Number*" name="mobile" id="uMobile" value="<?php echo e($driver->driver_phone); ?>" required>
                                                            <label class="error text-danger" hidden="" id="mobileError"> Mobile Number is invalid </label>
                                                        </div>
                                                    </div>
                                                    <div class="form-div">
                                                    </div>

                                                    <div class="form-div">
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label for="city">City applying for</label>
                                                            <input type="text" class="form-control" placeholder="City Applying for*" name="city" id="city" value="<?php echo e($driver->driver_city); ?>">
                                                            <label class="error text-danger" hidden="" id="cityError">City is required </label>
                                                        </div>
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label for="lName">Transporter Type *</label>
                                                            <select class="form-control transporttype " name="transporttype" id="transportType">
                                                                <option value="2 Wheeler" <?php if($driver->driver_transport_type === '2 Wheeler'): echo 'selected'; endif; ?>>2 wheeler</option>
                                                                <option value="3 Wheeler" <?php if($driver->driver_transport_type === '3 Wheeler'): echo 'selected'; endif; ?>>3 wheeler</option>
                                                                <option value="Van" <?php if($driver->driver_transport_type === 'Van'): echo 'selected'; endif; ?>> Vans</option>
                                                                <option value="Truck" <?php if($driver->driver_transport_type === 'Truck'): echo 'selected'; endif; ?>>Truck</option>
                                                            </select>
                                                            <label class="error text-danger" hidden="" id="transportTypeError"> Transporter Type is required </label>
                                                        </div>
                                                    </div>
                                                    <div class="form-div">
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label>Are you allowed to work in New Zealand?*</label>
                                                            <label>What type of visa do you hold?</label>
                                                            <select style="padding:0px;" class="form-control" name="visatype" id="visatype">
                                                                <option value="Student Visa" <?php if($driver->driver_visa_status === 'Student Visa'): echo 'selected'; endif; ?>>Student Visa</option>
                                                                <option value="Work Visa" <?php if($driver->driver_visa_status === 'Work Visa'): echo 'selected'; endif; ?>>Work Visa</option>
                                                                <option value="NZ Resident" <?php if($driver->driver_visa_status === 'NZ Resident'): echo 'selected'; endif; ?>>NZ Resident</option>
                                                            </select>
                                                            <label class="error text-danger" hidden="" id="visaError"> Visa Type is required </label>
                                                        </div>
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label for="lName">Make and model of vehicle</label>
                                                            <input type="text" class="form-control" placeholder="Make and model of vehicle" name="vmodel" id="vmodel" required="false" value=" <?php echo e($driver->driver_vehicle_num); ?>">
                                                            <label class="error text-danger" hidden="" id="vmodelError">Model of vehicle is required</label>
                                                        </div>
                                                    </div>
                                                    <div class="form-div">
                                                        <div class=" mg-b-pro-edt col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                            <label>Do you have your own vehicle?</label>
                                                            &nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="v" value="1" id="yes" <?php if($driver->driver_vehicle_owner === true): echo 'checked'; endif; ?>>&nbsp;&nbsp;Yes
                                                            &nbsp;&nbsp;<input type="radio" value="0" name="v" id="no" <?php if($driver->driver_vehicle_owner === false): echo 'checked'; endif; ?>>&nbsp;&nbsp;No
                                                            <label class="error text-danger" hidden="" id="vehicleError"> Vehicle field is required </label>
                                                        </div>
                                                    </div>
                                                </fieldset>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="text-center custom-pro-edt-ds">
                                                <button type="submit" class="btn btn-ctl-bt waves-effect waves-light m-r-10" name="event" value="add_boy" onclick="return checkDataBoy()">Update
                                                </button>
                                                <button type="button" class="btn btn-ctl-bt waves-effect waves-light" onclick="window.location = `<?php echo e(route('admin.listDrivers')); ?>`">Back
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/trustmoversfreight.com/resources/views/admin/update.blade.php ENDPATH**/ ?>