

<?php $__env->startSection('title'); ?> Vendor Dashboard <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('head-scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.6.2/chart.min.js" integrity="sha512-tMabqarPtykgDtdtSqCL3uLVM0gS1ZkUAVhRFu1vSEFgvB73niFQWJuvviDyBGBH22Lcau4rHB5p2K2T0Xvr6Q==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<script src="<?php echo e(asset('/js1/main.js')); ?>"></script>
<script src="<?php echo e(asset('/js1/adminlte.js')); ?>"></script>
<script src="<?php echo e(asset('/js1/demo.js')); ?>"></script>
<link rel="stylesheet" href="<?php echo e(asset('/css1/admin.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/css1/adminlte.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid ps-4 pe-4">
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12 mb-4">
                            <h3 style="text-align:left;font-family: 'Montserrat', sans-serif;" id="">Hello <?php echo e($vendors[0]->vendor_name); ?>,</h3>
                            <h4 style="text-align:left; color:rgb(124, 124, 124);font-family: 'Montserrat', sans-serif;" >Welcome back to your dashboard</h4>
                        </div>
                        <div class="col-md-12">
                            <!-- DONUT CHART -->
                            <div class="card ">
                                <div class="card-header card-honey">
                                    <h3 class="card-title">Order Status</h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-9 col-sm-12">
                                            <canvas id="donutChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                                        </div>
                                        <div class="col-lg-3 col-sm-12">
                                            <table class="status-table table table-striped table-borderless">
                                                <thead>
                                                    <tr>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>Ordered</td>
                                                        <td><?php echo e($orderStatuses->unassigned); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Ready</td>
                                                        <td><?php echo e($orderStatuses->assigned); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Pickup</td>
                                                        <td><?php echo e($orderStatuses->pickup); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Staged</td>
                                                        <td><?php echo e($orderStatuses->staged); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>In Transit</td>
                                                        <td><?php echo e($orderStatuses->in_transit); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Delivered</td>
                                                        <td><?php echo e($orderStatuses->delivered); ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.card-body -->
                            </div>
                            <!-- /.card -->
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- AREA CHART: Task Completion-Days -->
                            <div class="card">
                                <div class="card-header card-honey">
                                    <h3 class="card-title">Task Completion-Days</h3>

                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-7 col-md-12 col-sm-12">
                                            <div class="chart">
                                                <canvas id="areaChart" style="min-height: 250px; height: 350px; max-height: 350px; max-width: 100%;"></canvas>
                                            </div>
                                        </div>
                                        <div class="col-lg-5 col-md-12 col-sm-12">
                                            <table id="task-days-table" class="task-table table table-striped table-borderless">
                                                <thead>
                                                    <tr>
                                                        <td>Status</td>
                                                        <?php $__currentLoopData = $dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <td><?php echo e($date->format('d M')); ?></td>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $lineData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td>
                                                                <?php 
                                                                    if($data->order_status_name === "Unassigned") {
                                                                        print "Ordrered";
                                                                    } else if($data->order_status_name === "Assigned") {
                                                                        print "Ready";
                                                                    } else if($data->order_status_name === "Picked Up") {
                                                                        print "Pickup";
                                                                    } else {
                                                                        print $data->order_status_name;
                                                                    }
                                                                ?>
                                                            </td>
                                                            <td><?php echo e($data->day1); ?></td>
                                                            <td><?php echo e($data->day2); ?></td>
                                                            <td><?php echo e($data->day3); ?></td>
                                                            <td><?php echo e($data->day4); ?></td>
                                                            <td><?php echo e($data->day5); ?></td>
                                                            <td><?php echo e($data->day6); ?></td>
                                                            <td><?php echo e($data->day7); ?></td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.card -->

                        </div>
                        <!-- /.col (LEFT) -->
                        

                            <!-- STACKED BAR CHART -->
                            <div class="card">
                                <div class="card-header card-honey">
                                    <h3 class="card-title">Vendor Reports</h3>

                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="chart">
                                        <!-- <canvas id="stackedBarChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas> -->
                                        <!-- <div class="col-4"> -->
                                        <table id="agent-report-table" class="table table-striped table-borderless">
                                            <thead>
                                                <tr>
                                                    <th>Total no of Delivery</th>
                                                    <th>Total KM Travels</th>
                                                    <th>Total Fare</th>
                                                    <th>Total Of Extra Charges</th>
                                                    <th>Total Amount</th>
                                                    <th>Total cash Collected</th>
                                                    <th>Total order</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($vendor->total_delivered); ?></td>

                                                        <td><?php echo e($vendor->total_km); ?> KM</td>
                                                        <td><?php echo e($vendor->total_fare); ?> </td>
                                                        <td><?php echo e($vendor->total_extra_charges); ?> </td>
                                                        <td> <?php echo e($vendor->total_amount); ?></td>
                                                        <td>0.0 </td>
                                                        <td><?php echo e($vendor->total_orders); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                        <!-- </div> -->
                                    </div>
                                </div>
                            </div>

                            <!-- /.card -->
                        </div>
                        <!-- /.col (RIGHT) -->
                    </div>
                    <!-- /.row -->
                </div><!-- /.container-fluid -->
            </section>
            <!-- /.content -->
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('body-scripts'); ?>
<script>
    //     $(document).ready(function() {
    //         $('#task-days-table').DataTable();
    //     } );

    //     $(document).ready(function() {
    //         $('#task-agent-table').DataTable();
    //     } );

    //     $(document).ready(function() {
    //         $('#agent-report-table').DataTable();
    //     } );
    // 
</script>

<script>
    $(function() {
        /* ChartJS
         * -------
         * Here we will create a few charts using ChartJS
         */

        //--------------
        //- AREA CHART -
        //--------------

        // Get context with jQuery - using jQuery's .get() method.
        var areaChartCanvas = $('#areaChart').get(0).getContext('2d')
        var areaChartData = <?php echo $lineChart; ?>

        
        var areaChartOptions = {
            maintainAspectRatio: false,
            responsive: true,
            legend: {
                display: false
            },
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                    }
                }],
                yAxes: [{
                    gridLines: {
                        display: false,
                    }
                }]
            }
        }

        // This will get the first returned node in the jQuery collection.
        new Chart(areaChartCanvas, {
            type: 'line',
            data: areaChartData,
            options: areaChartOptions
        })


        //-------------
        // Get context with jQuery - using jQuery's .get() method.
        var donutChartCanvas = $('#donutChart').get(0).getContext('2d')
        var donutData = {
            labels: [
                'Ordered',
                'Ready',
                'Pickup',
                'Staged',
                'In Transit',
                'Delivered',
            ],
            datasets: [{
                data: ["<?php echo e($orderStatuses->unassigned); ?>", "<?php echo e($orderStatuses->assigned); ?>","<?php echo e($orderStatuses->pickup); ?>", "<?php echo e($orderStatuses->staged); ?>","<?php echo e($orderStatuses->in_transit); ?>", "<?php echo e($orderStatuses->delivered); ?>" ],
                //data: [4, 3, 5, 4],
                backgroundColor: ['#2ec4b6', '#ffbf69', '#cbf3f0', '#126782','#B65076', '#6C9EB5' ],
            }]
        }
        var donutOptions = {
            maintainAspectRatio: false,
            responsive: true,
        }
        //Create pie or douhnut chart
        // You can switch between pie and douhnut using the method below.
        new Chart(donutChartCanvas, {
            type: 'doughnut',
            data: donutData,
            options: donutOptions
        })

        //-------------
        //- PIE CHART -
        //-------------
        // Get context with jQuery - using jQuery's .get() method.
        var pieChartCanvas = $('#pieChart').get(0).getContext('2d')
        // var pieData        = donutData;
        var pieData = {
            labels: [
                'Busy',
                'Free',
            ],
            datasets: [{
                data: [700, 500],
                backgroundColor: ['#ffbf69', '#2ec4b6'],
            }]
        }
        var pieOptions = {
            maintainAspectRatio: false,
            responsive: true,
        }
        //Create pie or douhnut chart
        // You can switch between pie and douhnut using the method below.
        new Chart(pieChartCanvas, {
            type: 'doughnut',
            data: pieData,
            options: pieOptions
        })

        //-------------
        //- BAR CHART -
        //-------------
        var barChartCanvas = $('#barChart').get(0).getContext('2d')
        // var barChartData = $.extend(true, {}, areaChartData)


        var barChartData = {
            labels: ['Dona', 'Ayaka', 'Adi', 'Andrew', 'Saki', 'Diana', ],
            datasets: [{
                    label: 'Delivered',
                    backgroundColor: '#2ec4b6',
                    borderColor: '#2ec4b6',
                    pointRadius: false,
                    pointColor: '#2ec4b6',
                    pointStrokeColor: '#2ec4b6',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: '#2ec4b6',
                    data: [28, 48, 40, 19, 86, 27, 90]
                },
                {
                    label: 'In process',
                    backgroundColor: '#ffbf69',
                    borderColor: '#ffbf69',
                    pointRadius: false,
                    pointColor: '#ffbf69',
                    pointStrokeColor: '#ffbf69',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: '#ffbf69',
                    data: [40, 29, 68, 99, 56, 55, 33]
                },
                {
                    label: 'Accepted',
                    backgroundColor: '#cbf3f0',
                    borderColor: '#cbf3f0',
                    pointRadius: false,
                    pointColor: '#cbf3f0',
                    pointStrokeColor: '#cbf3f0',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: '#cbf3f0',
                    data: [65, 59, 80, 81, 56, 55, 40]
                },
            ]
        }

        var barChartOptions = {
            responsive: true,
            maintainAspectRatio: false,
            datasetFill: false
        }

        new Chart(barChartCanvas, {
            type: 'bar',
            data: barChartData,
            options: barChartOptions
        })

        //---------------------
        //- STACKED BAR CHART -
        //---------------------

        //     data: stackedBarChartData,
        //     options: stackedBarChartOptions
        //     })
    })
</script>
<script src="<?php echo e(asset('/js/jquery-3.2.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('/js/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('/js/main.js')); ?>"></script>
<script src="<?php echo e(asset('/js/plugins/pace.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('vendor.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/public_html/resources/views/vendor/dashboard.blade.php ENDPATH**/ ?>