<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-+0n0xVW2eSR5OomGNYDnhzAbDsOXxcvSN1TPprVMTNDbiYZCxYbOOl7+AMvyTG2x" crossorigin="anonymous">
    <title>Trust Movers</title>
    <style>
        .parcel .container {
            display: flex;
            justify-content: center;
        }

        .parcel-content {
            width: 354px;
            border: 1.5px solid #000;
            border-radius: 12px;
            padding: 1rem .25rem;
            height: 92%;
        }

        .parcel-content--item {
            border: 2px dotted #000;
            padding: .5rem;
            height: 96%;
        }

        .parcel-content--item-data {
            border: 2px solid #000;
            height: 96%;
        }

        .parcel-content--item-data1 {
            padding: 4px;
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
        }

        img {
            max-width: 100%;
        }

        .content h1 {
            font-size: 23px;
            padding-top: 1rem;
        }

        h4 {
            font-size: 14px;
        }

        h3 {
            font-size: 16px;
            font-weight: 700;
            text-decoration: underline;
        }

        .content-item {
            margin: 0.2rem 0 0.2rem 1.0rem;
        }

        p {
            margin-bottom: 0;
            font-size: 14px;
        }

        .content-2 {
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
            width: 100%;
            padding: 8px 0 8px 16px;
        }

        .content-2 {
            font-size: 14px;
            font-weight: 500;
        }

        .content-3 {
            border-bottom: 2px solid #000;
            width: 100%;
            padding: 1rem 0;
            font-size: 14px;
        }

        .content-2 table,
        .content-3 table {
            margin: 0px auto;
        }


        .content-4 {
            width: 100%;
            padding: 1rem 1.5rem 4px;
        }

        .content-4 p {
            font-size: 12px;
        }

        body {
            width: 98mm;
            height: 159mm;
        }

        @page  {
            margin: 12px;
        }

        .page_break {
            page-break-before: always;
        }
    </style>
</head>
<!-- <body onafterprint="afetrPrint()"> -->

<body>
    <?php for($item_key = 1; $item_key <= $package->quantity; $item_key++): ?>
        <div class="page-break">
            <section class="parcel">
                <div class="container">
                    <div class="parcel-content">
                        <div class="parcel-content--item">
                            <div class="parcel-content--item-data">
                                <div class="parcel-content--item-data1">
                                    <img src="<?php echo e(asset('/img/logo/trust.jpg')); ?>" alt="logo" height="60px">
                                    <div class="content">
                                        <h1>Moving & Delivery Specialists</h1>
                                        <div style="background-color: #000; color: #fff; padding: 4px; margin: 1rem 0; width: 100%;">
                                            <h4 id="refrence">Consignment Note B2C :- TM<?php echo e($package->order_id); ?></h4>
                                        </div>

                                        <h3>Receiver :</h3>
                                        <div class="content-item">
                                            <p id="custName"><b>Name : <?php echo e($package->order->receiver_first_name ."   ". $package->order->receiver_last_name); ?></b></p>
                                            <p id="custAdd"><b>Address : <?php echo e($package->order->receiver_address); ?></b></p>

                                        </div>
                                        <div class="content-item">

                                            <p id="refrence1">
                                                <strong>Sender Reference : </strong>
                                                <strong><?php echo e($package->order->vendor->vendor_name); ?></strong>
                                            </p>
                                        </div>
                                        <div class="content-item" style="margin-bottom: 1rem">
                                            <p id="custMobile"><b>Contact : <?php echo e($package->order->receiver_phone); ?></b></p>
                                        </div>
                                    </div>
                                    <div class="content-2">
                                        <table>
                                            <tr valign="top">
                                                <td style="width: 30%;"><b>Item:</b></td>
                                                <td style="width: 70%;">
                                                    <p><strong><?php echo e($package->quantity); ?> x <?php echo e($package->product_description); ?>: <?php echo e($package->reference_id); ?></strong></p>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="content-3">
                                        <table>
                                                <tr valign="top">
                                                    <td style="width: 30%;"><b>Sender : </b></td>
                                                    <td style="width: 70%;">
                                                        <b>
                                                            Name : <?php echo e($package->order->vendor->vendor_name); ?>

                                                        </b>
                                                    </td>
                                                </tr>
                                            </table>
                                    </div>
                                    <div class="content-4">
                                        <!--<img src="images/barcode.jpg" alt="barcode">
                                <p>Trust Movers & Freight</p>-->
                                    </div>
                                </div>
                            </div>
                            <p><?php echo e($item_key); ?> out of <?php echo e($package->quantity); ?></p>
                        </div>
                    </div>

                </div>
            </section>
        </div>
        <?php endfor; ?>
</body>

</html><?php /**PATH /home/w84938540/public_html/resources/views/pdf/package_label.blade.php ENDPATH**/ ?>