

<?php $__env->startSection('title'); ?> Order TM<?php echo e($order->order_id); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('head-scripts'); ?>
<!-- Bootstrap CSS -->
<link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('/img/trust.jpg')); ?>">


<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
<link href="https://use.fontawesome.com/releases/v5.7.0/css/all.css" rel="stylesheet">

<link rel="stylesheet" href="<?php echo e(asset('/wrd_file/tachyons.min.css')); ?>">
<link href="<?php echo e(asset('/wrd_file/css')); ?>" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(asset('/wrd_file/style.css')); ?>">
<link href="<?php echo e(asset('/css/vendor.css')); ?>" rel="stylesheet">

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery.add-input-area@4.11.0/dist/jquery.add-input-area.min.js" integrity="sha256-yOwGvcRp3I8/XWkeARhJkgdfLREQygbFA5W2bUpM2FY=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
<style>
    .product-status-wrap .modal-content {
        width: 1200px;
        margin: 0px auto;
    }

    .rb-container ul.rb li.current::before {
        border-color: green;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row dataList" style="margin: auto;">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align: left;">
            <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            <div class="product-status-wrap" style="width: 95vw; margin: auto;">
                <div class="modal-content" style="background-color: #f3f3f3">
                    <div class="modal-header">
                        <h5 class="modal-title">Order TM<?php echo e($order->order_id); ?></h5>
                        <h5 class="modal-title">Invoice <?php echo e($order->invoice_num); ?></h5>
                        <h5 class="modal-title">
                            <?php if($order->orderStatuses->isEmpty()): ?>
                            <a class="" href="#" onclick="event.preventDefault(); document.getElementById('confirm-order-form').submit();">
                                <button type="button" class="btnreq">Confirm</button>
                            </a>
                            <form id="confirm-order-form" action="<?php echo e(route('vendor.orders.confirm', $order)); ?>" method="POST" style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>
                            <?php endif; ?>
                        </h5>
                    </div>
                    <div class="row mb-2">
                        
                        <div class="col-6 mb-2">
                            <div class="card  mb-2">
                                <h5 class="card-header">Sender</h5>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-4">
                                                    <p class="text-muted">Name</p>
                                                </div>
                                                <div class="col-8">
                                                    <p class="card-text"><?php echo e($vendor->vendor_name); ?></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-4">
                                                    <p class="text-muted">Address</p>
                                                </div>
                                                <div class="col-8">
                                                    <p class="card-text"><?= str_replace('%', ',', $order->pickup_address) ?></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-3">
                                                    <p class="text-muted">Email</p>
                                                </div>
                                                <div class="col-9">
                                                    <p class="card-text"><?php echo e($vendor->email); ?></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-3">
                                                    <p class="text-muted">Phone</p>
                                                </div>
                                                <div class="col-9">
                                                    <p class="card-text"><?php echo e($vendor->vendor_mobile_num); ?></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-5">
                                                    <p class="text-muted">Pickup Date</p>
                                                </div>
                                                <div class="col-7">
                                                    <p class="card-text"><?php echo e($order->pickup_date); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="card">
                                <h5 class="card-header">Estimate</h5>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <p class="text-muted">Estimated Delivery Cost</p>
                                        </div>
                                        <div class="col-6">
                                            <p class="card-text">$ <?php echo e($order->estimated_delivery_charge); ?></p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <p class="text-muted">Estimated Distance</p>
                                        </div>
                                        <div class="col-6">
                                            <p class="card-text"><?php echo e($order->estimated_distance); ?> km</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-6 mb-2">
                            <div class="card">
                                <h5 class="card-header">Receiver</h5>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-4">
                                                    <p class="text-muted">Name</p>
                                                </div>
                                                <div class="col-8">
                                                    <p class="card-text"><?php echo e($order->receiver_first_name); ?> <?php echo e($order->receiver_last_name); ?></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-4">
                                                    <p class="text-muted">Address</p>
                                                </div>
                                                <div class="col-8">
                                                    <p class="card-text"><?= str_replace('%', ',', $order->receiver_address) ?></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-6">
                                                    <p class="text-muted">Drop Off Access</p>
                                                </div>
                                                <div class="col-6">
                                                    <p class="card-text"><?php echo e($order->drop_off_access); ?></p>
                                                </div>
                                                <div class="col-6">
                                                    <p class="text-muted">Floor</p>
                                                </div>
                                                <div class="col-6">
                                                    <p class="card-text">
                                                        <?php if( $order->drop_off_access === "Ground" ): ?>
                                                            0
                                                        <?php else: ?>
                                                            <?php echo e($order->floor); ?>

                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="row">
                                                <div class="col-3">
                                                    <p class="text-muted">Email</p>
                                                </div>
                                                <div class="col-9">
                                                    <p class="card-text"><?php echo e($order->receiver_email); ?></p>
                                                </div>
                                                <div class="col-3">
                                                    <p class="text-muted">Phone</p>
                                                </div>
                                                <div class="col-9">
                                                    <p class="card-text"><?php echo e($order->receiver_phone); ?></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-5">
                                                    <p class="text-muted">Delivery Date</p>
                                                </div>
                                                <div class="col-7">
                                                    <p class="card-text"><?php echo e($order->delivery_date); ?></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-3">
                                                    <p class="text-muted">Notes</p>
                                                </div>
                                                <div class="col-9">
                                                    <p class="card-text"><?php echo e($order->delivery_note); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-12 mb-2">
                            <div class="card" >
                                <h5 class="card-header">Freight Details</h5>
                                <div class="card-body">
                                    <div class="row">
                                        <table id="orderTable">
                                            <thead>
                                                <tr class="table-header">
                                                    <th>Reference #</th>
                                                    <th>Product Type</th>
                                                    <th>Description</th>
                                                    <th>Quantity</th>
                                                    <th>Length</th>
                                                    <th>Width</th>
                                                    <th>Height</th>
                                                    <th>Total Cubic</th>
                                                    <th>Weight</th>
                                                    <th>Installation</th>
                                                    <th>Unwrap</th>
                                                    <th>Fragile</th>
                                                <th><a href="<?php echo e(route('vendor.orders.print', $order)); ?>" target="_blank">Print All</a><br> (Thermal/A4)</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $order->packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="table-border">
                                                    <td><?php echo e($package->reference_id); ?></td>
                                                    <td><?php echo e($package->product_type); ?></td>
                                                    <td style="word-break:break-all"><?php echo e($package->product_description); ?></td>
                                                    <td><?php echo e($package->quantity); ?></td>
                                                    <td><?php echo e($package->length); ?> <?php echo e($package->unit); ?></td>
                                                    <td><?php echo e($package->width); ?> <?php echo e($package->unit); ?></td>
                                                    <td><?php echo e($package->height); ?> <?php echo e($package->unit); ?></td>
                                                    <td><?php echo e($package->cubic); ?> ㎥</td>
                                                    <td><?php echo e($package->weight); ?> Kg</td>
                                                    <td>
                                                        <?php if($package->installation === 1): ?>
                                                        <i class="fas fa-check"></i>
                                                        <?php else: ?>
                                                        <i class="fas fa-times"></i>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($package->unwrap === 1): ?>
                                                        <i class="fas fa-check"></i>
                                                        <?php else: ?>
                                                        <i class="fas fa-times"></i>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($package->fragile === 1): ?>
                                                        <i class="fas fa-check"></i>
                                                        <?php else: ?>
                                                        <i class="fas fa-times"></i>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo e(route('vendor.packages.print', $package)); ?>" target="_blank">
                                                            <i class="fa fa-print" aria-hidden="true"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-12 mb-2">
                            <div class="card">
                                <h5 class="card-header"><i class="fas fa-route"></i> HISTORY</h5>
                                <div class="card-body">
                                <link rel="stylesheet" href="<?php echo e(asset('/css1/app.css')); ?>">
                                <div class="trust">
                                    <div class="tab-panel" id="ex2-tabs-2" role="tabpanel" aria-labelledby="ex2-tab-2">
                                
                                            <div class="row content">
                                                <div class="container">
                                                    <div class="rb-container">
                                                        <ul class="rb">
                                                            <?php $__currentLoopData = $order->orderStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="<?php echo \Illuminate\Support\Arr::toCssClasses(['rb-item', 'current'=> $orderStatus->pivot->current]) ?>" ng-repeat="itembx">
                                                                <h5><?php echo e($orderStatus->order_status_name); ?></h5>
                                                                <div class="timestamp"><?php echo e($orderStatus->pivot->created_at->format('d/m/Y')); ?></div>
                                                                <div class="item-title"><?php echo e($orderStatus->pivot->remarks); ?></div>
                                                            </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                        </div>


                        
                        <div class="col-12 mb-2">
                            <div class="card">
                                <h5 class="card-header">Attachments</h5>
                                <div class="card-body">
                                    <div class="row">
                                        <table id="orderTable">
                                            <thead>
                                                <tr class="table-header">
                                                    <th>DATE</th>
                                                    <th>FILE NAME</th>
                                                    <th>REMARKS</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $order->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="table-border">
                                                    <td><?php echo e($image->created_at); ?></td>
                                                    <td><a href="/storage/<?php echo e($image->image_path); ?>" target="_blank"><?php echo e($image->original_file_name); ?></a></td>
                                                    <td><?php echo e($image->remarks); ?></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                        </div>

                        


                    </div>

            </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startPush('body-scripts'); ?>
<script>
    function calcOrderNumAndRefNum() {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);
        var ref = 'refNum_' + elemId;
        if (!document.getElementById("orderNum").value) {
            document.getElementById("orderNum").value = "Order" + Math.floor(Math.random() * 2000);
        }
        if (!document.getElementById(ref).value) {
            document.getElementById(ref).value = "Ref" + Math.floor(Math.random() * 1000);
        }
    }
</script>

<script>
    function openShelf() {
        document.getElementById("nav_shelf").style.width = "300px";
    }

    function closeShelf() {
        document.getElementById("nav_shelf").style.width = "0";
    }
    jQuery('.site-content').click(function() {
        return closeShelf();
    });
    $(document).ready(function() {
        $(".close").click(function() {
            $(".modal").fadeOut(1000);
        });
        $("#myBtn").click(function() {
            $(".modal").fadeIn(1000);
        });
        $("#myBtn1").click(function() {
            $(".modal").fadeIn(1000);
        });

        $(".close").click(function() {
            $(".btnreq").removeClass("active");
        });
        $(".close").click(function() {
            $(".active1").addClass("active");
        });
    });
</script>

<!-- Google API -->
<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=AIzaSyDVAjuVd5ARnE_xmdbKnlLTw8nyBnihK6Y&libraries=places"></script>
<script>
    $(document).ready(function() {
        $("#latitudeArea").addClass("d-none");
        $("#longtitudeArea").addClass("d-none");
    });
</script>
<script>
    // google.maps.event.addDomListener(window, 'load', initSenderAddress);
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById("map"), {
        center: {
            lat: -36.859482,
            lng: 174.4259345
        },
        zoom: 10,
        mapTypeControl: false,
    });
    // function initSenderAddress() {
    //     var input = document.getElementById('sender_address');
    //     var options = {
    //             componentRestrictions: {country: "nz"}
    //         };
    //     var autocomplete = new google.maps.places.Autocomplete(input, options);

    //     autocomplete.addListener('place_changed', function () {
    //         var place = autocomplete.getPlace();
    //         var pickupLat = place.geometry['location'].lat();
    //         var pickupLng = place.geometry['location'].lng();

    //         document.getElementById('pickupLat').value = pickupLat;
    //         document.getElementById('pickupLng').value = pickupLng;

    //         const pickupLatLng = { lat: pickupLat, lng: pickupLng };
    //         map = new google.maps.Map(document.getElementById("map"), {
    //             zoom: 10,
    //             center: pickupLatLng,
    //         });

    //         new google.maps.Marker({
    //             position: pickupLatLng,
    //             map,
    //             title: "Pickup Address",
    //         });
    //     });
    // }
    function codeAddress() {
        var address = document.getElementById('sender_address').value;
        console.log(address);
        geocoder.geocode({
            'address': address
        }, function(results, status) {
            if (status == 'OK') {
                document.getElementById('pickupLat').value = results[0].geometry.location.lat();
                document.getElementById('pickupLng').value = results[0].geometry.location.lng();
                console.log(results[0].geometry.location.lat());
                console.log(results[0].geometry.location.lng());
                map.setCenter(results[0].geometry.location);
                var marker = new google.maps.Marker({
                    map: map,
                    position: results[0].geometry.location
                });
            } else {
                alert('Geocode was not successful for the following reason: ' + status);
            }
        });
    }
</script>
<script>
    google.maps.event.addDomListener(window, 'load', initReceiverAddress);

    function initReceiverAddress() {
        var input = document.getElementById('receiver_address');
        // var autocomplete = new google.maps.places.Autocomplete(input);

        var options = {
            componentRestrictions: {
                country: "nz"
            }
        };
        var autocomplete = new google.maps.places.Autocomplete(input, options);

        autocomplete.addListener('place_changed', function() {
            var place = autocomplete.getPlace();
            var deliveryLat = place.geometry['location'].lat();
            var deliveryLng = place.geometry['location'].lng();

            const deliveryLatLng = {
                lat: deliveryLat,
                lng: deliveryLng
            };
            map = new google.maps.Map(document.getElementById("map"), {
                zoom: 10,
                center: deliveryLatLng,
            });

            pickupLat = document.getElementById('pickupLat').value;
            pickupLng = document.getElementById('pickupLng').value;

            const pickupLatLng = {
                lat: pickupLat,
                lng: pickupLng
            };
            pickup = new google.maps.Marker({
                position: pickupLatLng,
                map,
                title: "Pickup Address",
            });

            delivery = new google.maps.Marker({
                position: deliveryLatLng,
                map,
                title: "Delivery Address",
            });
        });
    }
</script>

<script>
    let selected = document.querySelector('[name="unit"]');

    selected.onchange = event => {
        var idx = selected.selectedIndex;
        var val = selected.options[idx].text;
        document.getElementsByClassName('unit')[0].textContent = val;
        document.getElementsByClassName('unit')[1].textContent = val;
        document.getElementsByClassName('unit')[2].textContent = val;
        measurementcubis();
    }
</script>

<!-- Measurement & Unit -->
<script>
    function cubic() {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);

        var c = 'cubic_' + elemId;

        document.getElementById('length_' + elemId).value = "";
        document.getElementById('height_' + elemId).value = "";
        document.getElementById('width_' + elemId).value = "";
    }

    function units() {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);

        var u = 'unit_' + elemId;
        console.log('u: ' + u)
        var selected = document.querySelector('[name="' + u + '"]');

        var idx = selected.selectedIndex;
        console.log('idx:' + idx);
        var val = selected.options[idx].text;
        console.log('val:' + val);
        document.getElementById('unit_l_' + elemId).textContent = val;
        document.getElementById('unit_h_' + elemId).textContent = val;
        document.getElementById('unit_w_' + elemId).textContent = val;
        measurements()
    }

    function measurements() {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);

        var length = document.getElementById('length_' + elemId).value;
        var height = document.getElementById('height_' + elemId).value;
        var width = document.getElementById('width_' + elemId).value;
        var result = parseFloat(height) * parseFloat(width) * parseFloat(length);
        var cubic = document.getElementById('cubic_' + elemId).value;
        var unit = document.getElementById('unit_' + elemId).value;

        if (unit === 'mm') {
            result = parseFloat(result) / 1000 / 1000 / 1000;
        } else if (unit === 'cm') {
            result = parseFloat(result) / 100 / 100 / 100;
        } else if (unit === 'm') {
            result = result;
        }
        result = Math.round(result * 100) / 100;

        if (result < 0.01) {
            document.getElementById('cubic_' + elemId).value = 0.01;
        } else {
            document.getElementById('cubic_' + elemId).value = result;
        }
    }
</script>

<!-- Duplicate inputs -->
<script type="text/javascript">
    $(function() {
        $('#list').addInputArea({
            maximum: 50
        });
    });
</script>

<!-- Tracking Details -->
<script>
    function trackingSubmit() {
        var trackingNum = document.getElementById("trackingId").value;
        if (trackingNum) {
            document.getElementById("trackingDetails").style.display = "block";
        } else {
            document.getElementById("trackingDetails").style.display = "none";
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('vendor.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/trustmoversfreight.com/resources/views/vendor/order_details.blade.php ENDPATH**/ ?>