<?php $__env->startSection('title'); ?> Route Run <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('head-scripts'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <h2><i class="fa-solid fa-map-location-dot"></i> Route Run</h2>
        <div class="row">
            <div class="col-lg-8 col-12">
                <div id="map" style="height:80vh" ></div>
            </div>
            <div class="col-lg-4 col-12">
                <div id="main-panel">
                    <div>
                        <div class="mb-2">
                            <b>Start:</b>
                            <select id="start_address" class="form-control dropdown">
                                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option id="start_address_warehouse_<?php echo e($loop->index); ?>" name="start_addresses" value="<?php echo e($warehouse->warehouse_address); ?>"><?php echo e($warehouse->warehouse_name); ?>: <?php echo e($warehouse->warehouse_address); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $pickup_tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pickup_date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $pickup_date; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pickup_task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option id="start_address_<?php echo e($loop->index); ?>" name="start_addresses" value="<?php echo e($pickup_task['receiver_address']); ?>"><?php echo e($pickup_task['receiver_address']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>

                        <div class="mb-4">
                            <b>End:</b>
                            <select id="end_address" class="form-control dropdown">
                                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option id="end_address_warehouse_<?php echo e($loop->index); ?>" name="end_addresses" value="<?php echo e($warehouse->warehouse_address); ?>"><?php echo e($warehouse->warehouse_name); ?>: <?php echo e($warehouse->warehouse_address); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $pickup_tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pickup_date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $pickup_date; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pickup_task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option id="end_address_<?php echo e($loop->index); ?>" name="end_addresses" value="<?php echo e($pickup_task['receiver_address']); ?>"><?php echo e($pickup_task['receiver_address']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-2">
                            <b>Date:</b>
                            <select id="pickup_date" class="form-control dropdown">
                                <?php $__currentLoopData = $pickup_tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pickup_date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option id="pickup_date_<?php echo e($loop->index); ?>" name="pickup_date" value="<?php echo e(array_search($pickup_date, $pickup_tasks)); ?>"><?php echo e(array_search($pickup_date, $pickup_tasks)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <input type="submit" class="btn btnAddFile" style="width:100%" id="submit_btn" value="See Pickup Route" />
                    </div>
                    <br>
                    <br>
                    <div>
                        <?php $__currentLoopData = $pickup_tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pickup_date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $pickup_date; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pickup_task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <input type="hidden" id="pickup_order_<?php echo e($loop->index); ?>" name="pickup_orders" value="<?php echo e($pickup_task['order_id']); ?>">
                        <input type="hidden" id="pickup_address_<?php echo e($loop->index); ?>" name="pickup_addresses" value="<?php echo e($pickup_task['receiver_address']); ?>">
                        <input type="hidden" id="pickup_date_<?php echo e($loop->index); ?>" name="pickup_dates" value="<?php echo e($pickup_task['pickup_date']); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div id="directions-route"></div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDVAjuVd5ARnE_xmdbKnlLTw8nyBnihK6Y&callback=initMap&libraries=places,geometry"></script>
    <script>
        function initMap() {
            const directionsService = new google.maps.DirectionsService();
            const directionsRenderer = new google.maps.DirectionsRenderer();
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 11,
                center: { lat: -36.9026073, lng: 174.7239558 },
            });
            directionsRenderer.setMap(map);
            document.getElementById("submit_btn").addEventListener("click", () => {
                calculateDisplayRoutes(directionsService, directionsRenderer);
            });
        }

        function calculateDisplayRoutes(directionsService, directionsRenderer) {

            var pickup_dates = document.getElementsByName("pickup_dates");
            var pickup_addresses = document.getElementsByName("pickup_addresses");
            const waypts = [];
            // const wayPointId = document.getElementById("waypoints").value;
            for (let i = 0; i < pickup_addresses.length; i++ ) {
                if ( pickup_addresses[i].value !== document.getElementById("start_address").value
                    && pickup_addresses[i].value !== document.getElementById("end_address").value
                    && pickup_dates[i].value ===  document.getElementById("pickup_date").value)
                {
                    waypts.push({
                        location: pickup_addresses[i].value,
                        stopover: true,
                    });
                }
            }
            console.log(document.getElementById("pickup_date").value)
            var pickup_orders = [];
            var pickup_orders_id = document.getElementsByName("pickup_orders");
            for (let i = 0; i < pickup_orders_id.length; i++ ) {
                pickup_orders += pickup_orders_id[i].value;
                console.log("pickup_orders: " + pickup_orders[i]);
            }

            var pickup_dates = [];
            pickup_dates_id = document.getElementsByName("pickup_dates");
            for (let i = 0; i < pickup_dates_id.length; i++ ) {
                pickup_dates += pickup_dates_id[i].value;
                console.log("pickup_dates: " + pickup_dates[i]);
            }

            directionsService.route({
                origin: document.getElementById("start_address").value,
                destination: document.getElementById("end_address").value,
                waypoints: waypts,
                optimizeWaypoints: true,
                travelMode: google.maps.TravelMode.DRIVING,
            },(response, status) => {
                if (status === "OK" && response) {
                    directionsRenderer.setDirections(response);
                    const route = response.routes[0];
                    const summaryPanel = document.getElementById("directions-route");
                    summaryPanel.innerHTML = "";

                    // For each route, display summary information.
                    for (let i = 0; i < route.legs.length; i++) {
                        const routeSegment = i + 1;
                        summaryPanel.innerHTML +=
                        "<b>Route Segment: " + routeSegment + "</b><br>";
                        // summaryPanel.innerHTML += "<b>TM# " + pickup_orders[i] + "</b><br>";
                        // summaryPanel.innerHTML += "<b>Pickup Date " + pickup_dates[i] + "</b><br>";
                        summaryPanel.innerHTML += route.legs[i].start_address + " to ";
                        summaryPanel.innerHTML += route.legs[i].end_address + "<br>";
                        summaryPanel.innerHTML +=
                        route.legs[i].distance.text + "<br><br>";
                    }
                } else {
                    window.alert("Directions request failed due to " + status);
                }
            }
        );
    }
    </script>

    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/public_html/resources/views/app/route_run.blade.php ENDPATH**/ ?>