<?php $__env->startSection('title'); ?> Vendor Reports <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs5/b-2.2.2/b-html5-2.2.2/sb-1.3.2/datatables.min.css" />
<style>
    .top {
        display: flex;
        align-items: center;
    }
</style>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="product-status-wrap">
        <div class="chart-container ng-star-inserted total-list">
            <h4 class="heading_h4" style="margin-left: 10px;  "><i class="fas fa-hotel"></i> Vendors List</h4>
            <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">x</button>
            </div>
            <?php endif; ?>
            <br>
            <table id="vendor-list-table">
                <thead>
                    <tr>
                        <th>Vendor Name</th>
                        <th>Email</th>
                        <th>Mobile</th>
                        <th>Vendor Address</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $vendor_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="<?php echo e($vendor->vendor_id); ?>">

                        <td><?php echo e($vendor->vendor_name); ?></td>
                        <td><?php echo e($vendor->email); ?></td>
                        <td><?php echo e($vendor->vendor_mobile_num); ?></td>
                        <td>
                            <?php $__currentLoopData = $vendor_addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor_address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if( $vendor->vendor_id == $vendor_address->vendor_id ): ?>
                            <?= str_replace('%', ',', $vendor_address->vendor_address) ?>
                            <br>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td>
                            <a data-toggle="tooltip" title="Edit" class="orders icons" href="<?php echo e(route('admin.vendors.edit', $vendor->vendor_id)); ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                            <a href="<?php echo e(route('admin.vendors.password.edit', $vendor)); ?>" class="orders icons"><i class="fas fa-key"></i></a>
                            <a onclick="event.preventDefault(); swalDelete('#delete-form-<?php echo e($vendor->vendor_id); ?>')" class="orders icons"><i class="fas fa-trash-alt"></i></a>
                            <form id="delete-form-<?php echo e($vendor->vendor_id); ?>" action="<?php echo e(route('admin.vendors.delete', $vendor)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('/js1/vendorList.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $('#vendor-list-table').DataTable();
    });

    function swalDelete(form_id) {
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert vendor!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, Delete vendor!',
      customClass: {
        confirmButton: 'btn btn-primary',
        cancelButton: 'btn btn-outline-danger ms-1'
      },
      buttonsStyling: false
    }).then(function(result) {
      if (result.value) {
        $(form_id).submit();

        Swal.fire({
          icon: 'success',
          title: 'Deleted!',
          text: 'Vendor has been deleted.',
          customClass: {
            confirmButton: 'btn btn-success'
          }
        });

      } else if (result.dismiss === Swal.DismissReason.cancel) {
        Swal.fire({
          title: 'Cancelled',
          text: 'Cancelled Delete :)',
          icon: 'error',
          customClass: {
            confirmButton: 'btn btn-success'
          }
        });
      }
    });
};
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/trustmoversfreight.com/resources/views/admin/vendor_list.blade.php ENDPATH**/ ?>