

<?php $__env->startSection('title'); ?> Delivery Tracker <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('head-scripts'); ?>
    
<?php $__env->startSection('content'); ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="DetailHeader h4">Order# TM<?php echo e($detail->order_id); ?></div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!-- Tabs navs -->
    <ul class="nav nav-pills nav-fill position-fixed" style="width: 100vw; background-color: #fcfcfc; margin-top: 65px; z-index: 10" id="pills-tab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="ex2-tab-1" data-bs-toggle="pill" data-bs-target="#ex2-tabs-1" type="button" role="tab" aria-controls="ex2-tab-1" aria-selected="true">Consignment</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="ex2-tab-2" data-bs-toggle="pill" data-bs-target="#ex2-tabs-2" type="button" role="tab" aria-controls="ex2-tab-2" aria-selected="false">History</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="ex2-tab-3" data-bs-toggle="pill" data-bs-target="#ex2-tabs-3" type="button" role="tab" aria-controls="ex2-tab-3" aria-selected="false">Attachments</button>
        </li>
    </ul>
    <!-- Tabs navs -->
    <!-- Tabs content -->
    <div class="tab-content" id="pills-tabContent" style="margin-top: 120px; margin-bottom: 100px;">

        <!-- Tab 1 -->
        <div class="tab-pane fade show active" id="ex2-tabs-1" role="tabpanel" aria-labelledby="ex2-tab-1">
            <div class="container">
                <div class="row content">
                    <h4 class="content_title"><i class="fa-solid fa-boxes-packing"></i> FROM</h4>
                    <?php if( $detail->task_type_id === 1 || $detail->task_type_id === 2  ): ?> 
                        <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> Vendor's Address: <?php echo e($detail->pickup_address); ?></div>
                    <?php elseif( $detail->task_type_id === 3  ): ?> 
                        <?php if( $detail->warehouse_id == 2 ): ?> 
                            <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> <?php echo e($detail->warehouse_name); ?>: <?php echo e($detail->pickup_address); ?></div>
                        <?php elseif( $detail->warehouse_id == 1 ): ?> 
                            <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> ( <?php echo e($detail->warehouse_name); ?> )</div>
                        <?php else: ?>
                            <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> <?php echo e($detail->warehouse_name); ?>: <?php echo e($detail->warehouse_address); ?></div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <div class="row content">
                    <h4 class="content_title"><i class="fa-solid fa-user"></i> VENDOR</h4>
                    <div class="col-6 mb-3"><i class="fas fa-user"></i> <?php echo e($detail->vendor_name); ?></div>
                    <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> <?php echo e($detail->pickup_address); ?></div>
                    <div class="col-12"><i class="fas fa-mobile-alt"></i> <a href="tel:+<?php echo e($detail->vendor_mobile_num); ?>">+<?php echo e($detail->vendor_mobile_num); ?></a></div>
                </div>
                <div class="row content">
                    <h4 class="content_title"><i class="fa-solid fa-box-archive"></i> TO</h4>
                    <?php if( $detail->warehouse_id == 1 ): ?>  
                        <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> ( <?php echo e($detail->warehouse_name); ?> )</div>
                    <?php else: ?>
                        <?php if( $detail->task_type_id === 1 ): ?> 
                            <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> Receiver's Address: 
                                <a href="https://www.google.com/maps/dir/?api=1&origin=<?php echo e($detail->pickup_address); ?>&destination=<?php echo e($detail->receiver_address); ?>&travelmode=driving" target="_blank"><?php echo e($detail->receiver_address); ?></a>
                            </div>
                        <?php elseif( $detail->task_type_id === 2  ): ?> 
                            <?php if( $detail->warehouse_id == 2 ): ?> 
                                <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> <?php echo e($detail->warehouse_name); ?>: 
                                    <a href="https://www.google.com/maps/dir/?api=1&origin=<?php echo e($detail->pickup_address); ?>&destination=<?php echo e($detail->receiver_address); ?>&travelmode=driving" target="_blank"><?php echo e($detail->receiver_address); ?></a>
                                </div>
                            <?php else: ?>
                                <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> <?php echo e($detail->warehouse_name); ?>: 
                                    <a href="https://www.google.com/maps/dir/?api=1&origin=<?php echo e($detail->pickup_address); ?>&destination=<?php echo e($detail->warehouse_address); ?>&travelmode=driving" target="_blank"><?php echo e($detail->warehouse_address); ?></a>
                                </div>
                            <?php endif; ?>
                        <?php elseif( $detail->task_type_id === 3  ): ?> 
                            <?php if( $detail->warehouse_id == 2 ): ?> 
                                <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> Receiver's Address: 
                                    <a href="https://www.google.com/maps/dir/?api=1&origin=<?php echo e($detail->pickup_address); ?>&destination=<?php echo e($detail->receiver_address); ?>&travelmode=driving" target="_blank"><?php echo e($detail->receiver_address); ?></a>
                                </div>
                            <?php else: ?>
                                <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> Receiver's Address: 
                                    <a href="https://www.google.com/maps/dir/?api=1&origin=<?php echo e($detail->warehouse_address); ?>&destination=<?php echo e($detail->receiver_address); ?>&travelmode=driving" target="_blank"><?php echo e($detail->receiver_address); ?></a>
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <p>something wrong...</p>
                        <?php endif; ?>
                    <?php endif; ?>

                </div>
                <div class="row content">
                    <h4 class="content_title"><i class="fa-solid fa-person-chalkboard"></i> CUSTOMER</h4>
                    <div class="col-6 mb-3"><i class="fas fa-user"></i> <?php echo e($detail->receiver_first_name . " " . $detail->receiver_last_name); ?> </div>
                    <div class="col-6 mb-3">Reference:  
                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($package->reference_id); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> <?php echo e($detail->receiver_address); ?></div>
                    <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> Drop off Access: <?php echo e($detail->drop_off_access); ?></div>
                    <div class="col-12 mb-3"><i class="fas fa-map-marker-alt"></i> Floor: 
                        <?php if($detail->drop_off_access === "Ground"): ?> 
                            0 
                        <?php else: ?> 
                            <?php echo e($detail->floor); ?>

                        <?php endif; ?>
                    </div>
                    <div class="col-12 mb-3"><i class="fas fa-mobile-alt"></i> <a href="tel:+<?php echo e($detail->receiver_phone); ?>">+<?php echo e($detail->receiver_phone); ?></a></div>
                </div>
                <div class="row content" style="overflow-x: scroll;">
                    <h4 class="content_title"><i class="fas fa-box"></i> FREIGHT</h4>
                    <table class="table small">
                        <thead>
                            <tr class="small p-0">
                                <th class="p-1">No.</th>
                                <th class="p-1">Product Type</th>
                                <th class="p-1">Description</th>
                                <th class="p-1">Installation</th>
                                <th class="p-1">Unwrap</th>
                                <th class="p-1">Fragile</th>
                                <th class="p-1">Qty</th>
                                <th class="p-1">m3</th>
                                <th class="p-1">Kg</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="small">
                                <td class="p-1"><?php echo e($package->reference_id); ?></td>
                                <td class="p-1"><?php echo e($package->product_type); ?></td>
                                <td class="p-1"><?php echo e($package->product_description); ?></td>
                                <td class="p-1">
                                    <?php if($package->installation === 1): ?>
                                        <i class="fas fa-check"></i>
                                    <?php else: ?>
                                        <i class="fas fa-times"></i>
                                    <?php endif; ?>
                                </td>
                                <td class="p-1">
                                    <?php if($package->unwrap === 1): ?>
                                        <i class="fas fa-check"></i>
                                    <?php else: ?>
                                        <i class="fas fa-times"></i>
                                    <?php endif; ?>
                                </td>
                                <td class="p-1">
                                    <?php if($package->fragile === 1): ?>
                                        <i class="fas fa-check"></i>
                                    <?php else: ?>
                                        <i class="fas fa-times"></i>
                                    <?php endif; ?>
                                </td>
                                <td class="p-1"><?php echo e($package->quantity); ?></td>
                                <td class="p-1"><?php echo e($package->cubic); ?></td>
                                <td class="p-1"><?php echo e($package->weight); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <div class="d-flex justify-content-end small">
                        <div class="p-3">TOTAL: <?php echo e($total_quantity[ $detail->task_id ] ?? ''); ?> items(s)</div>
                        <div class="p-3"><?php echo e($total_cubic[ $detail->task_id ] ?? ''); ?> m3</div>
                        <div class="p-3"><?php echo e($total_weight[ $detail->task_id ] ?? ''); ?> kg</div>
                    </div>
                </div>
                <div class="row content">
                    <h4 class="content_title"><i class="fas fa-clipboard"></i> NOTES & INSTRUCTIONS</h4>
                    <div class="col-12"><?php echo e($detail->delivery_note); ?></div>
                </div>
            </div>
        </div>
        
        <!-- Tab 2 -->
        <div class="tab-pane fade" id="ex2-tabs-2" role="tabpanel" aria-labelledby="ex2-tab-2" >
        
            <div class="container">
                <div class="row content">
                    <h4 class="content_title"><i class="fas fa-route"></i> HISTORY</h4>
                    <div class="container">
                        <div class="rb-container">
                            <ul class="rb">

                                <?php $__currentLoopData = $orderStatusHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderStatusHistory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="rb-item" ng-repeat="itembx">
                                    <h5><?php echo e($orderStatusHistory->order_status_name); ?></h5>
                                    <div class="timestamp"><?php echo e($orderStatusHistory->created_at); ?></div>
                                    <div class="item-title"><?php echo e($orderStatusHistory->remarks); ?></div>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>

        <!-- Tab 3 -->
        <div class="tab-pane fade" id="ex2-tabs-3" role="tabpanel" aria-labelledby="ex2-tab-3" >
            <div class="container">
                <div class="row content">
                    <h4 class="content_title mb-4"><i class="fas fa-images"></i> Attachments</h4>
                    <form name="imageUploadForm" method="post" action="<?php echo e(route('driver.task.addAttachment')); ?>" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <input type="hidden" name="order_id" value="<?php echo e($detail->order_id); ?>">
                        <input type="hidden" name="task_id" value="<?php echo e($detail->task_id); ?>">
                        <input id="photo" type="file" name="photo" class="mb-2" style="display: inherit" accept="image/png, image/jpeg">
                        <input type="text" class="form-control mb-2" name="remarks" value="" placeholder="remarks if any">
                        <div class="text-end">
                            <button id="btnAddFile" type="button" class="btn btnAddFile w-100" onclick="imageUpload()">Add File</button>
                        </div>
                    </form>
                    <div class="row content-end">
                        <div class="col">
                            <a href="<?php echo e(route('app.signature', $detail->task_id)); ?>">Add Signature</a>
                        </div>
                    </div>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>DATE</th>
                                <th>FILE NAME</th>
                                <th>REMARKS</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($image->uploaded_at); ?></td>
                                <td><a href="/storage/<?php echo e($image->image_path); ?>" target="_blank"><?php echo e($image->original_file_name); ?></a></td>
                                <td><?php echo e($image->remarks); ?></td>
                                
                                <td></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Tabs content -->

    <!-- Button trigger modal -->
    <?php if( $currentTaskStatus->task_status_id == 4 ): ?>
        
    <?php else: ?>
        <div class="DetailFooter h4 bottom-0 mb-0">
            <button class="btn btn-confirm w-100 p-3" style="min-height: inherit; font-size: 1.4rem" data-bs-toggle="modal" data-bs-target="#statusModal">
                <i class="fas fa-angle-double-right"></i> Change Status to <?php echo e($order_status[$nextOrderStatus_id]); ?>

            </button>
        </div>
    <?php endif; ?>

    <!-- Modal -->
    <div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="statusModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="statusModalLabel">Change Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form name="updateStatusForm" method="post" action="<?php echo e(route('driver.task.updateOrderStatus')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="order_id" value="<?php echo e($currentOrderStatus->order_id); ?>">
                        <input type="hidden" name="task_id" value="<?php echo e($currentOrderStatus->task_id); ?>">
                        <input type="hidden" name="order_status_id" value="<?php echo e($currentOrderStatus->order_status_id); ?>">
                        
                        
                        <?php if( $currentOrderStatus->order_status_id === 6 || $currentOrderStatus->order_status_id === 7 ): ?>
                            <li><input type="radio" id="order_status_<?php echo e($currentOrderStatus->order_status_id); ?>" name="order_status" value="<?php echo e($currentOrderStatus->order_status_id); ?>" checked readonly> <label for="order_status_<?php echo e($currentOrderStatus->order_status_id); ?>"><?php echo e($order_status[$currentOrderStatus->order_status_id]); ?></label></li>
                        <?php else: ?>
                            <li><input type="radio" id="order_status_<?php echo e($nextOrderStatus_id); ?>" name="order_status" value="<?php echo e($nextOrderStatus_id); ?>" checked readonly> <label for="order_status_<?php echo e($nextOrderStatus_id); ?>"><?php echo e($order_status[$nextOrderStatus_id]); ?></label></li>
                            <br>
                            <li><input type="radio" id="order_status_7" name="order_status" value="7" <?php echo e($currentOrderStatus->order_status_id == 7 ? 'checked': null); ?>> <label for="order_status_7"><?php echo e($order_status[7]); ?></label></li>
                        <?php endif; ?>
                        <br>
                        <b>Remarks</b><input type="text" name="order_status_remakrs" class="form-control" placeholder="Remarks if any">
                    </form>
                </div>
                <div class="modal-footer">
                    
                    <button type="button" class="btn btnAddFile" onclick="saveStatus()"><i class="fa-solid fa-circle-check"></i> Update Status</button>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        function imageUpload() {
            var btn = document.getElementById('btn');
            var photo = document.getElementById('photo');
            
            if( !photo.value.trim() ) {
                alert('Please choose an image first.');
            } else {
                document.imageUploadForm.submit();
            }
        }
        function saveStatus() {
            console.log('savestatus');
            document.updateStatusForm.submit();
        }

      </script>
    <?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('app.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/trustmoversfreight.com/resources/views/app/details.blade.php ENDPATH**/ ?>