<?php $__env->startSection('title'); ?> Vendor Dashboard <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<style>
input.cubic {
    width: 100px;
}
/* For Firefox */
input[type='number'] {
    -moz-appearance:textfield;
}

/* Webkit browsers like Safari and Chrome */
input[type=number]::-webkit-inner-spin-button,
input[type=number]::-webkit-outer-spin-button {
    -webkit-appearance: none;
    margin: 0;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('head-scripts'); ?>

<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<section class="pt0-ns clearset">

    <form id="reqForm" tabindex="500" class="form-set" action="<?php echo e(route('vendor.orders.store')); ?>" method="POST" autocomplete="off">

        <?php echo e(csrf_field()); ?>


        <input type="hidden" name="event" value="add_order">
        <input type="hidden" name="vendor_id" id="vendor_id" value="<?php echo e($vendor->vendor_id); ?>">
        <input type="hidden" name="vendor_email" id="vendor_email" value="<?php echo e($vendor->email); ?>">

        <div class="container centerDiv">
            <fieldset>
                <div class="row">
                    <legend><i class="fas fa-user-circle"></i> Vendor Information</legend>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-6 col-sm-6">
                        <label for="vendor_fname">Name</label>
                        <input id="vendor_fname" class="form-control ng-untouched ng-pristine ng-invalid" placeholder="First Name" style="text-transform: capitalize;" type="text" value="<?php echo e($vendor->vendor_name); ?>" name="first_name" autocomplete="off" required />
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 col-sm-6">
                        <label for="vendor_email">Email Address</label>
                        <input id="vendor_email" required class="form-control ng-untouched ng-pristine ng-invalid" placeholder="Email Address" type="text" value="<?php echo e($vendor->email); ?>" name="email" autocomplete="off" />
                    </div>

                    <div class="col-md-6 col-sm-6">
                        <label for="vendor_phone">Phone Number</label>
                        <div style="display: flex;">
                            <input class="form-control" style="width: 20%;" type="text" value="+64" />
                            <input id="vendor_phone" required class="form-control ng-untouched ng-pristine ng-invalid" placeholder="Phone Number" style="width: 80%;" type="text" value=" <?php echo e($vendor->vendor_mobile_num); ?>" name="phone_no" autocomplete="off" />
                        </div>
                    </div>
                </div>

                <hr class="horizon">

                <!--Buttons-->
                <div class="row">
                    <legend><i class="fas fa-box"></i> Delivery Request</legend>
                    <div class="col-md-12 col-sm-12">
                        <button type="button" class="btn btn-primary btnMenu" data-bs-toggle="modal" data-bs-target="#pickupModal">
                            1. Pickup / From <i class="fas fa-chevron-circle-right"></i>
                        </button>
                    </div>
                </div>
                <div class="row" style="display: none;">
                    <div class="col-md-12 col-sm-12">
                        <button type="button" class="btn btn-primary btnMenu" data-bs-toggle="modal" data-bs-target="#deliverModal">
                            2. Delivery / To <i class="fas fa-chevron-circle-right"></i>
                        </button>
                    </div>
                </div>
                <div class="row" style="display: none;">
                    <div class="col-md-12 col-sm-12">
                        <button type="button" class="btn btn-primary btnMenu" data-bs-toggle="modal" data-bs-target="#AddItemsModal">
                            3. Add Items <i class="fas fa-chevron-circle-right"></i>
                        </button>
                    </div>
                </div>
            </fieldset>

            <!-- pickupModal -->
            <div class="modal fade" id="pickupModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="pickupModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="pickupModalLabel">1. Pickup / From</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <fieldset>
                                <legend>Pickup Address</legend>
                                <div class="row">
                                    <div class="col-md-12 col-sm-12">
                                        <p id="errmsg" class="errmsg"></p>
                                        <label for="pickup_address">Address</label>
                                        <!--<input id="sender_address" class="form-control address" type="text" placeholder="Address" name="street-address" />-->
                                        <select id="pickup_address" required class="form-control address" name="pickup_address" type="text" placeholder="Address" onchange="codeAddress()">
                                            <option>- Choose Pickup Location -</option>
                                            <?php $__currentLoopData = $vendor->vendorAddresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locations): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?=str_replace('%', ',', $locations->vendor_address  )?>" <?php if(old('pickup_address') === str_replace('%', ',', $locations->vendor_address )): echo 'selected'; endif; ?>><?=str_replace('%', ',', $locations->vendor_address  )?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <input type="hidden" id="pickup_zip_code" name="pickup_zip_code" value="<?php echo e(old('pickup_zip_code')); ?>">
                                        <input id="pickup_latitude" name="pickup_latitude" value="<?php echo e(old('pickup_latitude')); ?>" type="hidden"></p>
                                        <input id="pickup_longitude" name="pickup_longitude" value="<?php echo e(old('pickup_longitude')); ?>" type="hidden"></p>
                                    </div>
                                </div>
                            </fieldset>
                            <fieldset>
                                <legend>Pickup Detail</legend>
                                <div class="row">
                                    <div class="col-md-6 col-sm-6">
                                        <label for="pickup_date">Pickup Date</label>
                                        <input type="date" id="pickup_date" value="<?php echo e(old('pickup_date')); ?>" required class="form-control ng-untouched ng-pristine ng-invalid" style="text-transform: capitalize;text-transform: capitalize" type="text" name="pickup_date">
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fas fa-times-circle"></i> Close</button>
                            <button type="button" class="btn btn-primary" onclick="pickupValidate()">Next <i class="fas fa-arrow-circle-right"></i></button>
                        </div>
                    </div>
                    <!--modal-content-->
                </div>
                <!--modal-dialog-->
            </div>

            <!-- deliverModal -->
            <div class="modal fade" id="deliverModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deliverModaldropLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deliverModalLabel">2. Deliver / To</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <fieldset>
                                <legend>Delivery Address</legend>
                                <div class="row">
                                    <div class="col-md-12 col-sm-12">
                                        <label for="receiver_address">Address</label>
                                        <input id="receiver_address" class="form-control address" value="<?php echo e(old('receiver_address')); ?>" type="text" placeholder="Address" name="receiver_address" />
                                        <p id="errReceiverAddress" class="errmsg"></p>
                                        <input type="hidden" id="receiver_zip_code" name="receiver_zip_code" value="<?php echo e(old('receiver_zip_code')); ?>">
                                        <input id="receiver_latitude" name="receiver_latitude" value="<?php echo e(old('receiver_latitude')); ?>" type="hidden"></p>
                                        <input id="receiver_longitude" name="receiver_longitude" value="<?php echo e(old('receiver_longitude')); ?>" type="hidden"></p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-4 align-items-baseline">
                                        <label for="drop_off_access" class="mb-2">Drop Off Access</label><br>
                                        <label for="stair">
                                            <input type="radio" id="stair" name="drop_off_access" value="Stairs" onclick="dropOffAccess('stair')" <?php if(old('drop_off_access') === 'Stairs'): echo 'checked'; endif; ?>> Stairs
                                        </label>
                                        <label for="lift">
                                            <input type="radio" id="lift" name="drop_off_access" value="Lift" onclick="dropOffAccess('lift')" <?php if(old('drop_off_access') === 'Lift'): echo 'checked'; endif; ?>> Lift
                                        </label>
                                        <label for="groundfloor">
                                            <input type="radio" id="groundfloor" name="drop_off_access" value="Ground" onclick="dropOffAccess('groundfloor')"
                                            <?php echo e(old('drop_off_access','Ground') === 'Ground' ? 'checked' : ''); ?> > Ground Floor
                                        </label>
                                        <br>
                                        <p id="errStairOrLift" class="errmsg"></p>
                                    </div>

                                    <div class="col-2 align-items-baseline">
                                        <label for="vendor_floor_fares" class="mb-2">Floor</label><br>
                                        <select class="form-control" id="floor" name="floor" disabled style="background-color:#cccccc"
                                        <?php if(old('drop_off_access') =='Ground' ): echo 'disabled'; endif; ?>
                                        <?php if(old('drop_off_access')==='Ground' ): ?> style="background-color:#cccccc" <?php endif; ?>>
                                            <?php $__currentLoopData = $vendor->vendorFloorFares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value->floor_num); ?>" <?php if(old('floor') === $value->floor_num): echo 'selected'; endif; ?>><?php echo e($value->floor_num); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <p id="errFloor" class="errmsg"></p>
                                    </div>
                                </div>
                            </fieldset>

                            <fieldset>
                                <legend>Customer Information</legend>
                                <div class="row">
                                    <div class="col-md-6 col-sm-6">
                                        <label for="receiver_first_name">First Name</label>
                                        <input id="receiver_first_name" class="form-control ng-untouched ng-pristine ng-invalid" style="text-transform: capitalize;text-transform: capitalize" type="text" placeholder="First Name" type="text" name="receiver_first_name" value="<?php echo e(old('receiver_first_name')); ?>" />
                                        <p id="errReceiverFirstName" class="errmsg"></p>
                                    </div>

                                    <div class="col-md-6 col-sm-6">
                                        <label for="receiver_last_name">Last Name</label>
                                        <input id="receiver_last_name" class="form-control ng-untouched ng-pristine ng-invalid" style="text-transform: capitalize;text-transform: capitalize" type="text" placeholder="Last Name" type="text" name="receiver_last_name" value="<?php echo e(old('receiver_last_name')); ?>" />
                                        <p id="errReceiverLastName" class="errmsg"></p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 col-sm-6">
                                        <label for="receiver_email">Email Address</label>
                                        <input id="receiver_email" class="form-control ng-untouched ng-pristine ng-invalid" placeholder="Email Address" type="text" name="receiver_email" value="<?php echo e(old('receiver_email')); ?>" />
                                        <p id="errReceiverEmail" class="errmsg"></p>
                                    </div>


                                    <div class="col-md-6 col-sm-6">
                                        <label for="receiver_phone">Phone Number</label>
                                        <div class="input-group">
                                            <span class="input-group-text">+64</span>
                                            <input id="receiver_phone" class="form-control ng-untouched ng-pristine ng-invalid" placeholder="Phone Number" type="tel" name="receiver_phone" value="<?php echo e(old('receiver_phone')); ?>" />
                                        </div>
                                        <p id="errReceiverPhone" class="errmsg"></p>
                                    </div>
                                </div>
                            </fieldset>

                            <fieldset>
                                <legend>Delivery Detail</legend>
                                <div class="row">
                                    <div class="col-md-6 col-sm-6">
                                        <label for="delivery_date">Delivery Date</label>
                                        <input type="date" id="delivery_date" class="form-control ng-untouched ng-pristine ng-invalid" style="text-transform: capitalize;text-transform: capitalize" type="text" name="delivery_date" value="<?php echo e(old('delivery_date')); ?>">
                                        <p id="errDeliverydate" class="errmsg"></p>
                                    </div>
                                    <div class="col-md-6 col-sm-6">
                                        <label for="delivery_note">Delivery Note</label>
                                        <textarea class="form-control" id="deliverynote" name="remark" rows="5" cols="30" placeholder="Delivery Note if any" name="delivery_note"><?php echo e(old('remark')); ?></textarea>
                                        <p id="errmsg" class="errmsg"></p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 col-sm-12">
                                        Estimated Distance: <input id="estimated_km" type="text" value="<?php echo e(old('totalEstimatedKm')); ?>" name="totalEstimatedKm"> km
                                    </div>
                                    <div class="col-md-12 col-sm-12">
                                        <div id="map" style="height: 300px;"></div>
                                    </div>
                                </div>
                            </fieldset>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-bs-toggle="modal" href="#pickupModal"><i class="fas fa-arrow-circle-left"></i> Previous</button>
                            <button type="button" class="btn btn-primary" onclick="deliverValidate()">Next <i class="fas fa-arrow-circle-right"></i></button>
                        </div>
                    </div>
                    <!--modal-content-->
                </div>
                <!--modal-dialog-->
            </div>

            <!-- consignmentItemsModal -->
            <div class="modal fade" id="consignmentItemsModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="consignmentItemsModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="consignmentItemsModalLabel">3. Consignment Items</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal" data-bs-toggle="modal" href="#AddItemsModal"><i class="fas fa-plus-circle"></i> Add Items</button>
                                    <br>
                                    <br>
                                    <div style="overflow: auto;">
                                        <table id="myTable1" class="tblConsignmentItems">
                                            <tr class="trConsignmentItems">
                                                <th class="thConsignmentItems">Ref #</th>
                                                <th class="thConsignmentItems">Size</th>
                                                <th class="thConsignmentItems">Installation</th>
                                                <th class="thConsignmentItems">Unwrap</th>
                                                <th class="thConsignmentItems">Qty</th>
                                                <th class="thConsignmentItems biggerCol">Description</th>
                                                <th class="thConsignmentItems ">Total Kgs</th>
                                                <th class="thConsignmentItems biggerCol">L * W * H (m) </th>
                                                <th class="thConsignmentItems">Cubic</th>
                                                <th class="thConsignmentItems biggerCol">Actions</th>
                                            </tr>
                                            <tr id="1" class="trConsignmentItems">
                                                <td class="tdConsignmentItems" style="max-width: 80px;"><input class="readOnly" style="width: 100%;" type="text" id="refrences1" name="refrences1" value="1726 " readonly="true"></td>

                                                <input type="hidden" name="refrence1" id="refrence1" value="1726">
                                                <td class="tdConsignmentItems" style="max-width: 30px; "><input class="readOnly" style="width: 100%; text-align: center;" type="text" name="productSize1" id="productSize1" value="M"></td>
                                                <td class="tdConsignmentItems" style="max-width: 30px;"><input class="readOnly" style="width: 100%; text-align: center;" type="text" name="installation1" id="installation1" value="Y"></td>
                                                <td class="tdConsignmentItems" style="max-width: 30px;"><input class="readOnly" style="width: 100%; text-align: center;" type="text" name="unwrap1" id="unwrap1" value="N"></td>
                                                <td class="tdConsignmentItems" style="max-width: 30px;"><input class="readOnly" style="width: 100%; text-align: center;" type="text" name="Qty1" id="Qty1" value="1"></td>
                                                <td class="tdConsignmentItems biggerCol"><input class="readOnly" style="width: 100%; text-align: center;" type="text" name="description1" id="description1" value="package name"></td>
                                                <td class="tdConsignmentItems"><input class="readOnly" style="width: 100%; text-align: center;" type="text" name="totalweight1" id="totalweight1" value="0.3"></td>
                                                <td class="tdConsignmentItems biggerCol">
                                                    <input class="readOnly" style="width: 25%; text-align: center;" type="text" name="length1" id="length1" value="0.2"> x
                                                    <input class="readOnly" style="width: 25%; text-align: center;" type="text" name="width1" id="width1" value="0.3"> x
                                                    <input class="readOnly" style="width: 25%; text-align: center;" type="text" name="hight1" id="hight1" value="0.4">
                                                </td>
                                                <td class="tdConsignmentItems" style="max-width: 30px;"><input class="readOnly" style="width: 100%; text-align: center;" type="text" name="cubic1" id="cubic1" value="0.3"></td>
                                                <td class="tdConsignmentItems" style="font-size: 18px;"><i class="fas fa-edit"></i>&nbsp;&nbsp;<i class="fas fa-trash-alt"></i>&nbsp;&nbsp;<i class="fas fa-print"></i></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-bs-toggle="modal" href="#deliverModal"><i class="fas fa-arrow-circle-left"></i> Previous</button>
                            <button type="button" class="btn btn-primary" data-bs-dismiss="modal" data-bs-toggle="modal" href="#">Next <i class="fas fa-arrow-circle-right"></i></button>
                        </div>
                    </div>
                    <!--modal-content-->
                </div>
                <!--modal-dialog-->
            </div>

            <!-- OrderInvoiceModal -->
            <div class="modal fade" id="AddItemsModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="AddItemsModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="AddItemsModalLabel">Order Invoice</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                            <fieldset>
                                <legend>Item Detail</legend>
                                <div class="row">
                                    <div class="col-3">
                                        <label for="invNum">Invoice#</label>
                                        <input id="invNum" class="form-control" type="text" placeholder="inv001" name="invNum" value="<?php echo e(old('invNum')); ?>" />
                                        <p id="errInvNum" class="errmsg"></p>
                                    </div>
                                </div>
                                <?php
                                    $packages = old('packages', [])
                                ?>
                                <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="form-group" id="list">
                                    <div class="list_var">
                                        <div class="duplicate mb-2" style="background-color: #fdf5e0; padding: 0.5rem; border-radius: 1rem;">
                                            <div class="row">
                                                <div class="col-2">
                                                    <label for="refNum_<?php echo e($key); ?>">Reference#</label>
                                                    <input id="refNum_<?php echo e($key); ?>" value="<?php echo e($package['refNum']); ?>" name="packages[<?php echo e($key); ?>][refNum]" data-name-format="packages[%d][refNum]" class="form-control readOnly" type="text" placeholder="ref001" readonly />
                                                    <p id="errRefNum_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>
                                                <div class="col-3">
                                                    <label for="productType_0">Product Type</label>
                                                    <select class="form-control" id="productType_<?php echo e($key); ?>" type="text" name="packages[<?php echo e($key); ?>][product_type]" data-name-format="packages[%d][product_type]" onchange="calcOrderNumAndRefNum()">

                                                        <option value="Select">Select</option>
                                                        <option value="Carton" <?php if($package['product_type']==='Carton' ): echo 'selected'; endif; ?>>Carton</option>
                                                        <option value="Pallets" <?php if($package['product_type']==='Pallets' ): echo 'selected'; endif; ?>>Pallets</option>
                                                        <option value="Stock move" <?php if($package['product_type']==='Stock move' ): echo 'selected'; endif; ?>>Stock move</option>
                                                        <option value="Appliances" <?php if($package['product_type']==='Appliances' ): echo 'selected'; endif; ?>>Appliances</option>
                                                        <option value="Furniture" <?php if($package['product_type']==='Furniture' ): echo 'selected'; endif; ?>>Furniture</option>
                                                        <option value="Hazardous goods" <?php if($package['product_type']==='Hazardous goods' ): echo 'selected'; endif; ?>>Hazardous goods</option>
                                                        <option value="others" <?php if($package['product_type']==='others' ): echo 'selected'; endif; ?>>others</option>
                                                    </select>
                                                    <p id="errProductType_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="description_<?php echo e($key); ?>">Description</label>
                                                    <input id="description_<?php echo e($key); ?>" class="form-control" style="min-width: fit-content;" type="text" placeholder="Description" name="packages[<?php echo e($key); ?>][description]" data-name-format="packages[%d][description]" value="<?php echo e($package['description']); ?>" />
                                                    <p id="errDescription_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>

                                            </div>
                                            <div class="row justify-content-center align-items-start">

                                                <div class="col align-items-baseline" style="min-width: fit-content">
                                                    <label for="options_0" class="mb-2">Options</label><br>
                                                    <label for="installation_0">
                                                        <input type="checkbox" id="installation_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][installation]" data-name-format="packages[%d][installation]" value="1" onclick="selectedOptions('installation')" <?php if(array_key_exists('installation', $package)): echo 'checked'; endif; ?>> Installation
                                                    </label>
                                                    <label for="unwrap_0">
                                                        <input type="checkbox" id="unwrap_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][unwrap]" data-name-format="packages[%d][unwrap]" value="1" onclick="selectedOptions('unwrap')" <?php if(array_key_exists('unwrap', $package)): echo 'checked'; endif; ?>> Unwrap
                                                    </label>
                                                    <label for="fragile_0">
                                                        <input type="checkbox" id="fragile_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][fragile]" data-name-format="packages[%d][fragile]" value="1" onclick="selectedOptions('fragile')" <?php if(array_key_exists('fragile', $package)): echo 'checked'; endif; ?>> Fragile
                                                    </label>
                                                    <label for="none_0">
                                                        <input type="checkbox" id="none_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][none]" data-name-format="packages[0][none]" value="1" data-empty-val="false" onclick="selectedOptions('none')" <?php if(array_key_exists('none', $package)): echo 'checked'; endif; ?>> None
                                                    </label>
                                                </div>

                                            </div>
                                            <div class="row justify-content-center align-items-end">

                                                <div class="col">
                                                    <label for="unit_<?php echo e($key); ?>">Unit</label>
                                                    <select id="unit_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][unit]" data-name-format="packages[%d][unit]" class="form-control" style="width: fit-content;" type="text" onchange="units()">
                                                        <option value="mm" <?php if($package['unit']==='mm' ): echo 'selected'; endif; ?>>mm</option>
                                                        <option value="cm" <?php if($package['unit']==='cm' ): echo 'selected'; endif; ?> <?php if(empty($package['unit'])): ?> selected <?php endif; ?>>cm</option>
                                                        <option value="m" <?php if($package['unit']==='m' ): echo 'selected'; endif; ?>>m</option>
                                                    </select>
                                                    <p id="errUnit_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="quantity_<?php echo e($key); ?>">Quantity</label>
                                                    <input id="quantity_<?php echo e($key); ?>" class="form-control" type="text" value="<?php echo e($package['quantity']); ?>" placeholder="0" name="packages[<?php echo e($key); ?>][quantity]" data-name-format="packages[%d][quantity]" onchange="measurements()" />
                                                    <p id="errQuantity_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="length_<?php echo e($key); ?>">Length <br>(<label id="unit_l_<?php echo e($key); ?>" name="unit_l_<?php echo e($key); ?>">cm</label>)</label>
                                                    <input id="length_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][length]" value="<?php echo e($package['length']); ?>" data-name-format="packages[%d][length]" class="form-control" type="number" placeholder="-.-" onchange="measurements()" />
                                                    <p id="errLength_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="height_<?php echo e($key); ?>">Height <br>(<label id="unit_h_<?php echo e($key); ?>" name="unit_h_<?php echo e($key); ?>">cm</label>)</label>
                                                    <input id="height_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][height]" value="<?php echo e($package['height']); ?>" data-name-format="packages[%d][height]" class="form-control" type="number" placeholder="-.-" onchange="measurements()" />
                                                    <p id="errHeight_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="width_<?php echo e($key); ?>">Width <br>(<label id="unit_w_<?php echo e($key); ?>" name="unit_w_<?php echo e($key); ?>">cm</label>)</label>
                                                    <input id="width_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][width]" value="<?php echo e($package['width']); ?>" data-name-format="packages[%d][width]" class="form-control" type="number" placeholder="-.-" onchange="measurements()" />
                                                    <p id="errWidth_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>
                                                <div class="col" style="margin-bottom: 15px;">
                                                    <label for="cubic_<?php echo e($key); ?>">Cubic <br>(m3)</label>
                                                    <input id="cubic_<?php echo e($key); ?>" name="packages[<?php echo e($key); ?>][cubic]" value="<?php echo e($package['cubic']); ?>" data-name-format="packages[%d][cubic]" class="form-control cubic" type="text" placeholder="-.-" onchange="cubic()" />
                                                </div>
                                                <div class="col">
                                                    <label for="weight_<?php echo e($key); ?>">Weight (kg)</label>
                                                    <input id="weight_<?php echo e($key); ?>" class="form-control" type="text" value="<?php echo e($package['weight']); ?>" placeholder="0.0" name="packages[<?php echo e($key); ?>][weight]" data-name-format="packages[%d][weight]" value="" />
                                                    <p id="errWeight_<?php echo e($key); ?>" class="errmsg"></p>
                                                </div>
                                                <div class="col-2" style="padding: 5px; margin-bottom: 15px;">
                                                    <button id="plus_<?php echo e($key); ?>" name="plus_<?php echo e($key); ?>" type="button" class="list_add btn btn-info btn-round"><i class="fas fa-plus"></i></button>
                                                    <button id="minus_<?php echo e($key); ?>" name="minus_<?php echo e($key); ?>" type="button" class="list_del btn btn-danger btn-round"><i class="fas fa-minus"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="form-group" id="list">
                                    <div class="list_var">
                                        <div class="duplicate mb-2" style="background-color: #fdf5e0; padding: 0.5rem; border-radius: 1rem;">
                                            <div class="row">
                                                <div class="col-2">
                                                    <label for="refNum_0">Reference#</label>
                                                    <input id="refNum_0" name="packages[0][refNum]" data-name-format="packages[%d][refNum]" class="form-control readOnly" type="text" placeholder="ref001" readonly />
                                                    <p id="errRefNum_0" class="errmsg"></p>
                                                </div>
                                                <div class="col-3">
                                                    <label for="productType_0">Product Type</label>
                                                    <select class="form-control" id="productType_0" type="text" name="packages[0][product_type]" data-name-format="packages[%d][product_type]" onchange="calcOrderNumAndRefNum()">

                                                        <option value="Select">Select</option>
                                                        <option value="Carton">Carton</option>
                                                        <option value="Pallets">Pallets</option>
                                                        <option value="Stock move">Stock move</option>
                                                        <option value="Appliances">Appliances</option>
                                                        <option value="Furniture">Furniture</option>
                                                        <option value="Hazardous goods">Hazardous goods</option>
                                                        <option value="others">others</option>
                                                    </select>
                                                    <p id="errProductType_0" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="description_0">Description</label>
                                                    <input id="description_0" class="form-control" style="min-width: fit-content;" type="text" placeholder="Description" name="packages[0][description]" data-name-format="packages[%d][description]" value="" />
                                                    <p id="errDescription_0" class="errmsg"></p>
                                                </div>

                                            </div>
                                            <div class="row justify-content-center align-items-start">

                                                <div class="col align-items-baseline" style="min-width: fit-content">
                                                    <label for="options_0" class="mb-2">Options</label><br>
                                                    <label for="installation_0">
                                                        <input type="checkbox" id="installation_0" name="packages[0][installation]" data-name-format="packages[%d][installation]" value="1" onclick="selectedOptions('installation')"> Installation
                                                    </label>
                                                    <label for="unwrap_0">
                                                        <input type="checkbox" id="unwrap_0" name="packages[0][unwrap]" data-name-format="packages[%d][unwrap]" value="1" onclick="selectedOptions('unwrap')"> Unwrap
                                                    </label>
                                                    <label for="fragile_0">
                                                        <input type="checkbox" id="fragile_0" name="packages[0][fragile]" data-name-format="packages[%d][fragile]" value="1" onclick="selectedOptions('fragile')"> Fragile
                                                    </label>
                                                    <label for="none_0">
                                                        <input type="checkbox" id="none_0" name="packages[0][none]" data-name-format="packages[0][none]" value="1" data-empty-val="false" onclick="selectedOptions('none')" checked> None
                                                    </label>
                                                </div>

                                            </div>
                                            <div class="row justify-content-center align-items-end">

                                                <div class="col">
                                                    <label for="unit_0">Unit</label>
                                                    <select id="unit_0" name="packages[0][unit]" data-name-format="packages[%d][unit]" class="form-control" style="width: fit-content;" type="text" onchange="units()">
                                                        <option value="mm">mm</option>
                                                        <option value="cm" selected>cm</option>
                                                        <option value="m">m</option>
                                                    </select>
                                                    <p id="errUnit_0" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="quantity_0">Quantity</label>
                                                    <input id="quantity_0" class="form-control" type="text" placeholder="0" name="packages[0][quantity]" data-name-format="packages[%d][quantity]" onchange="measurements()" />
                                                    <p id="errQuantity_0" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="length_0">Length <br>(<label id="unit_l_0" name="unit_l_0">cm</label>)</label>
                                                    <input id="length_0" name="packages[0][length]" data-name-format="packages[%d][length]" class="form-control" type="text" placeholder="-.-" onchange="measurements()" />
                                                    <p id="errLength_0" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="height_0">Height <br>(<label id="unit_h_0" name="unit_h_0">cm</label>)</label>
                                                    <input id="height_0" name="packages[0][height]" data-name-format="packages[%d][height]" class="form-control" type="text" placeholder="-.-" onchange="measurements()" />
                                                    <p id="errHeight_0" class="errmsg"></p>
                                                </div>
                                                <div class="col">
                                                    <label for="width_0">Width <br>(<label id="unit_w_0" name="unit_w_0">cm</label>)</label>
                                                    <input id="width_0" name="packages[0][width]" data-name-format="packages[%d][width]" class="form-control" type="text" placeholder="-.-" onchange="measurements()" />
                                                    <p id="errWidth_0" class="errmsg"></p>
                                                </div>
                                                <div class="col" style="margin-bottom: 15px;">
                                                    <label for="cubic_0">Cubic <br>(m3)</label>
                                                    <input id="cubic_0" name="packages[0][cubic]" data-name-format="packages[%d][cubic]" class="form-control cubic" type="text" placeholder="-.-" onchange="cubic()" />
                                                </div>
                                                <div class="col">
                                                    <label for="weight_0">Weight (kg)</label>
                                                    <input id="weight_0" class="form-control" type="text" placeholder="0.0" name="packages[0][weight]" data-name-format="packages[%d][weight]" value="" />
                                                    <p id="errWeight_0" class="errmsg"></p>
                                                </div>
                                                <div class="col-2" style="padding: 5px; margin-bottom: 15px;">
                                                    <button id="plus_0" name="plus_0" type="button" class="list_add btn btn-info btn-round"><i class="fas fa-plus"></i></button>
                                                    <button id="minus_0" name="minus_0" type="button" class="list_del btn btn-danger btn-round"><i class="fas fa-minus"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>


                            </fieldset>

                        </div>
                        <div>
                            <p id="errPickupModal" class="errmsg"></p>
                            <p id="errDeliverModal" class="errmsg"></p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-bs-toggle="modal" href="#deliverModal"><i class="fas fa-arrow-circle-left"></i> Previous</button>
                            <a type="button" class="btn btn-primary" onclick="itemValidate()">Estimate <i class="fas fa-arrow-circle-right"></i></a><br>
                            <!--<button type="submit" class="btn btn-primary" data-bs-dismiss="modal" data-bs-toggle="modal" href="#estimateModal">Estimate <i class="fas fa-arrow-circle-right"></i></button>-->
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </form>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('body-scripts'); ?>
<script>
    function calcOrderNumAndRefNum() {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);
        var ref = 'refNum_' + elemId;
        if (!document.getElementById(ref).value) {
            document.getElementById(ref).value = "Ref" + Math.floor(Math.random() * 1000);
        }
    }
</script>

<script>
    function openShelf() {
        document.getElementById("nav_shelf").style.width = "300px";
    }

    function closeShelf() {
        document.getElementById("nav_shelf").style.width = "0";
    }
    jQuery('.site-content').click(function() {
        return closeShelf();
    });
    $(document).ready(function() {
        $(".close").click(function() {
            $(".modal").fadeOut(1000);
        });
        $("#myBtn").click(function() {
            $(".modal").fadeIn(1000);
        });
        $("#myBtn1").click(function() {
            $(".modal").fadeIn(1000);
        });

        $(".close").click(function() {
            $(".btnreq").removeClass("active");
        });
        $(".close").click(function() {
            $(".active1").addClass("active");
        });
    });
</script>

<!-- Google API -->
<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=AIzaSyB9AnSA3IsTgIhUwWzn0E-ToPs30axhDzU&libraries=places"></script>

<script>
    $(document).ready(function() {
        $("#latitudeArea").addClass("d-none");
        $("#longtitudeArea").addClass("d-none");
        let pickupLat = parseFloat(document.getElementById('pickup_latitude').value);
        let pickupLng = parseFloat(document.getElementById('pickup_longitude').value);
        let receiverLat = parseFloat(document.getElementById('receiver_latitude').value);
        let receiverLng = parseFloat(document.getElementById('receiver_longitude').value);
        const pickupLatLng = {
            lat: pickupLat,
            lng: pickupLng
        };

        const receiverLatLng = {
                lat: receiverLat,
                lng: receiverLng
            };
        if(pickupLat || pickupLng || receiverLat || receiverLng) {
            map = new google.maps.Map(document.getElementById("map"), {
                zoom: 10,
                center: receiverLatLng,
            });

            pickup = new google.maps.Marker({
                position: pickupLatLng,
                map,
                title: "Pickup Address",
                icon: "https://maps.google.com/mapfiles/kml/paddle/P.png"
            });
            console.log(pickup);
            delivery = new google.maps.Marker({
                position: receiverLatLng,
                map,
                title: "Delivery Address",
                icon: "https://maps.google.com/mapfiles/kml/paddle/D.png"
            });
        }
    });
</script>
<script>
    // google.maps.event.addDomListener(window, 'load', initSenderAddress);
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById("map"), {
        center: {
            lat: -36.859482,
            lng: 174.4259345
        },
        zoom: 10,
        mapTypeControl: false,
    });

    function codeAddress() {
        var address = document.getElementById('pickup_address').value;
        console.log(address);
        geocoder.geocode({
            'address': address
        }, function(results, status) {
            if (status == 'OK') {
                document.getElementById('pickup_latitude').value = results[0].geometry.location.lat();
                document.getElementById('pickup_longitude').value = results[0].geometry.location.lng();
                /*
                for (var i = 0; i < results.address_components.length; i++) {
                    for (var j = 0; j < results.address_components[i].types.length; j++) {
                        if (results.address_components[i].types[j] == "postal_code") {
                            document.getElementById('pickup_zip_code').value = results.address_components[i].long_name;
                            console.log(results.address_components[i].long_name);
                        }
                    }
                }
                */
                $.each(results[0].address_components,function(index,value){
                    if(value.types[0] === "postal_code"){
                        $('#pickup_zip_code').val(value.long_name);
                    }
                });
                console.log(results[0].geometry.location.lat());
                console.log(results[0].geometry.location.lng());
                map.setCenter(results[0].geometry.location);
                var marker = new google.maps.Marker({
                    map: map,
                    position: results[0].geometry.location
                });
            } else {
                alert('Geocode was not successful for the following reason: ' + status);
            }
        });
    }
</script>
<script>
    google.maps.event.addDomListener(window, 'load', initReceiverAddress);

    function haversine_distance(pickup, delivery) {
        var R = 6371.0710; // Radius of the Earth in meters
        var rlat1 = pickup.position.lat() * (Math.PI / 180);
        // Convert degrees to radians
        var rlat2 = delivery.position.lat() * (Math.PI / 180);
        // Convert degrees to radians
        var difflat = rlat2 - rlat1; // Radian difference (latitudes)
        var difflon = (delivery.position.lng() - pickup.position.lng()) *
            (Math.PI / 180); // Radian difference (longitudes)

        var d = 2 * R *
            Math.asin(Math.sqrt(Math.sin(difflat / 2) * Math.sin(difflat / 2) +
                Math.cos(rlat1) * Math.cos(rlat2) *
                Math.sin(difflon / 2) * Math.sin(difflon / 2)));
        return d;
    }

    function initReceiverAddress() {
        var input = document.getElementById('receiver_address');
        // var autocomplete = new google.maps.places.Autocomplete(input);

        var options = {
            componentRestrictions: {
                country: "nz"
            }
        };
        var autocomplete = new google.maps.places.Autocomplete(input, options);

        autocomplete.addListener('place_changed', function() {
            var place = autocomplete.getPlace();
            document.getElementById('receiver_latitude').value = place.geometry['location'].lat();
            document.getElementById('receiver_longitude').value = place.geometry['location'].lng();
            var deliveryLat = place.geometry['location'].lat();
            var deliveryLng = place.geometry['location'].lng();
            for (var i = 0; i < place.address_components.length; i++) {
                    for (var j = 0; j < place.address_components[i].types.length; j++) {
                        if (place.address_components[i].types[j] == "postal_code") {
                            document.getElementById('receiver_zip_code').value = place.address_components[i].long_name;
                        }
                    }
                }

            const deliveryLatLng = {
                lat: deliveryLat,
                lng: deliveryLng
            };
            map = new google.maps.Map(document.getElementById("map"), {
                zoom: 10,
                center: deliveryLatLng,
            });

            let pickupLat = parseFloat(document.getElementById('pickup_latitude').value);
            let pickupLng = parseFloat(document.getElementById('pickup_longitude').value);

            const pickupLatLng = {
                lat: pickupLat,
                lng: pickupLng
            };
            pickup = new google.maps.Marker({
                position: pickupLatLng,
                map,
                title: "Pickup Address",
                icon: "https://maps.google.com/mapfiles/kml/paddle/P.png"
            });
            console.log(pickup);
            delivery = new google.maps.Marker({
                position: deliveryLatLng,
                map,
                title: "Delivery Address",
                icon: "https://maps.google.com/mapfiles/kml/paddle/D.png"
            });

            //var line = new google.maps.Polyline({path: [pickupLatLng, deliveryLatLng], map: map});

            // Calculate and display the distance between markers
            var distance = haversine_distance(pickup, delivery);
            console.log("Distance between markers: " + distance.toFixed(2) + " km.");

            //   document.getElementById('estimated_km').val(distance.toFixed(2));

            let directionsService = new google.maps.DirectionsService();
            let directionsRenderer = new google.maps.DirectionsRenderer();
            directionsRenderer.setMap(map); // Existing map object displays directions
            // Create route from existing points used for markers
            const route = {
                origin: pickup.position,
                destination: delivery.position,
                travelMode: 'DRIVING',
            }

            directionsService.route(route,
                function(response, status) { // anonymous function to capture directions
                if (status !== 'OK') {
                    window.alert('Directions request failed due to ' + status);
                    return;
                } else {
                    directionsRenderer.setDirections(response); // Add route to the map
                    var directionsData = response.routes[0].legs[0]; // Get data about the mapped route
                    if (!directionsData) {
                        window.alert('Directions request failed');
                        return;
                    } else {
                        console.log("Driving distance is " + directionsData.distance.text + " (" + directionsData.duration.text + ").");
                        var distance_km = directionsData.distance.text.replace(/,(?!["{}[\]])/g, "");
                        
                        $("#estimated_km").val(distance_km.replace(" km", ""));
                    }
                }
            });
        });
    }
</script>

<!-- Drop Off Access -->
<script>
    function dropOffAccess(access) {
        // const floor = document.getElementById('floor');
        if (access === "groundfloor") {
            document.getElementById('floor').disabled = true;
            document.getElementById('floor').style.backgroundColor = "#cccccc";
        } else {
            document.getElementById('floor').disabled = false;
            document.getElementById('floor').style.backgroundColor = "";
        }
    }
</script>

<!-- Measurement & Unit -->
<script>
    function cubic() {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);

        var c = 'cubic_' + elemId;

        document.getElementById('length_' + elemId).value = "";
        document.getElementById('height_' + elemId).value = "";
        document.getElementById('width_' + elemId).value = "";
    }

    function units() {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);

        var u = 'unit_' + elemId;
        console.log('u: ' + u)
        var selected = document.querySelector('[id="' + u + '"]');

        var idx = selected.selectedIndex;
        console.log('idx:' + idx);
        var val = selected.options[idx].text;
        console.log('val:' + val);
        document.getElementById('unit_l_' + elemId).textContent = val;
        document.getElementById('unit_h_' + elemId).textContent = val;
        document.getElementById('unit_w_' + elemId).textContent = val;
        measurements()
    }

    function measurements() {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);

        var quantity = document.getElementById('quantity_' + elemId).value;
        var length = document.getElementById('length_' + elemId).value;
        var height = document.getElementById('height_' + elemId).value;
        var width = document.getElementById('width_' + elemId).value;
        var result = parseFloat(height) * parseFloat(width) * parseFloat(length);
        var cubic = document.getElementById('cubic_' + elemId).value;
        var unit = document.getElementById('unit_' + elemId).value;

        if (unit === 'mm') {
            result = parseFloat(result) / 1000 / 1000 / 1000;
        } else if (unit === 'cm') {
            result = parseFloat(result) / 100 / 100 / 100;
        } else if (unit === 'm') {
            result = result;
        }
        result = (result * quantity * 100) / 100;
        if(!isNaN(result)) {
            document.getElementById('cubic_' + elemId).value = result;
        }
    }
</script>


<!-- Form Validation -->
<script>
    // =======================================================
    // Pickup modal
    // =======================================================
    // blank validation for pickup modal
    const pickupValidate = () => {
        const sender_address = document.getElementById('pickup_address');
        const pickupdate = document.getElementById('pickup_date');
        const errmsg = document.getElementById('errmsg');
        var errCnt = 0;
        if (sender_address.value === "- Choose Pickup Location -" || !pickupdate.value.trim()) {
            errmsg.innerText = "Please select every field.";
            errCnt = 1;
        } else {
            errmsg.innerText = "";
            var currentModalEl = document.getElementById('pickupModal');
            var currentModal = bootstrap.Modal.getInstance(currentModalEl)
            currentModal.hide();
            var deliverModal = new bootstrap.Modal(document.getElementById('deliverModal'))
            deliverModal.show()
        }
        return errCnt;
    };

    // =======================================================
    // Deliver modal
    // =======================================================
    // blank validation for deliver modal
    const deliverValidate = () => {
        // target id
        const receiver_address = document.getElementById('receiver_address');
        const stair = document.getElementById('stair');
        const lift = document.getElementById('lift');
        const groundfloor = document.getElementById('groundfloor');
        const receiver_firstName = document.getElementById('receiver_first_name');
        const receiver_lastName = document.getElementById('receiver_first_name');
        // const receiver_email = document.getElementById('receiver_email');
        const receiver_phone = document.getElementById('receiver_phone');
        const deliverydate = document.getElementById('delivery_date');

        // err msg
        const errReceiverAddress = document.getElementById('errReceiverAddress');
        const errStairOrLift = document.getElementById('errStairOrLift');
        const errReceiverFirstName = document.getElementById('errReceiverFirstName');
        const errReceiverLastName = document.getElementById('errReceiverLastName');
        // const errReceiverEmail = document.getElementById('errReceiverEmail');
        const errReceiverPhone = document.getElementById('errReceiverPhone');
        const errDeliverydate = document.getElementById('errDeliverydate');

        var errCnt = 0;
        if (!receiver_address.value.trim()) {
            errReceiverAddress.innerText = "Please enter delivery address.";
            errCnt++;
        } else {
            errReceiverAddress.innerText = "";
        }
        if (!stair.checked && !lift.checked && !groundfloor.checked) {
            errStairOrLift.innerText = "Please select one of Drop off Access.";
        } else {
            errStairOrLift.innerText = "";
        }
        if (!receiver_firstName.value.trim()) {
            errReceiverFirstName.innerText = "Please enter receiver's first name.";
            errCnt++;
        } else {
            errReceiverFirstName.innerText = "";
        }
        if (!receiver_lastName.value.trim()) {
            errReceiverLastName.innerText = "Please enter receiver's last name.";
            errCnt++;
        } else {
            errReceiverLastName.innerText = "";
        }
        // if( !receiver_email.value.trim() ) {
        //     errReceiverEmail.innerText = "Please enter receiver's email address.";
        //     errCnt++;
        // } else {
        //     errReceiverEmail.innerText = "";
        // }
        if (!receiver_phone.value.trim()) {
            errReceiverPhone.innerText = "Please enter receiver's phone number.";
            errCnt++;
        } else {
            errReceiverPhone.innerText = "";
        }
        if (!deliverydate.value.trim()) {
            errDeliverydate.innerText = "Please select a delivery date.";
            errCnt++;
        } else {
            errDeliverydate.innerText = "";
        }
        if (errCnt === 0) {
            var currentModalEl = document.getElementById('deliverModal');
            var currentModal = bootstrap.Modal.getInstance(currentModalEl)
            currentModal.hide();
            var AddItemsModal = new bootstrap.Modal(document.getElementById('AddItemsModal'))
            AddItemsModal.show()
        }

        return errCnt;
    };

    // =======================================================
    // Item modal
    // =======================================================
    const itemValidate = () => {

        const listRefNum = document.querySelectorAll(`[id^="refNum_"]`);
        const refNumLength = listRefNum.length;
        console.log('refNumLength: ' + refNumLength);

        // target id
        const invNum = document.getElementById('invNum');
        const orderNum = document.querySelectorAll(`[id^="orderNum_"]`);
        const refNum = document.querySelectorAll(`[id^="refNum_"]`);
        const description = document.querySelectorAll(`[id^="description_"]`);
        const productType = document.querySelectorAll(`[id^="productType_"]`);
        // const height = document.querySelectorAll(`[id^="height_"]`);
        // const width = document.querySelectorAll(`[id^="width_"]`);
        // const length = document.querySelectorAll(`[id^="length_"]`);
        // const weight = document.querySelectorAll(`[id^="weight_"]`);
        const quantity = document.querySelectorAll(`[id^="quantity_"]`);

        // // err msg
        const errInvNum = document.getElementById('errInvNum');
        const errOrderNum = document.querySelectorAll(`[id^="errOrderNum_"]`);
        const errRefNum = document.querySelectorAll(`[id^="errRefNum_"]`);
        const errDescription = document.querySelectorAll(`[id^="errDescription_"]`);
        const errProductType = document.querySelectorAll(`[id^="errProductType_"]`);
        const errHeight = document.querySelectorAll(`[id^="errHeight_"]`);
        const errWidth = document.querySelectorAll(`[id^="errWidth_"]`);
        const errLength = document.querySelectorAll(`[id^="errLength_"]`);
        const errWeight = document.querySelectorAll(`[id^="errWeight_"]`);
        const errQuantity = document.querySelectorAll(`[id^="errQuantity_"]`);

        var errCnt = 0;

        for (let i = 0; i < refNumLength; i++) {

            // if (!refNum[i].value.trim()) {
            //     errRefNum[i].innerText = "Please enter reference number.";
            //     errCnt++;
            // } else {
            //     errRefNum[i].innerText = "";
            // }
            if (!description[i].value.trim()) {
                errDescription[i].innerText = "Please enter product's description.";
                errCnt++;
            // } else if(description[i].value.trim().length > 40) {
            //     errDescription[i].innerText = "Please limit the description to 40 characters";
            //     errCnt++;
            } else {
                errDescription[i].innerText = "";
            }
            // if (stair[i].checked === false  && lift[i].checked === false) {
            //     errStairOrLift[i].innerText = "Please select Stair or Lift.";
            //     errCnt++;
            // } else {
            //     errStairOrLift[i].innerText = "";
            // }
            if (productType[i].value === "Select") {
                errProductType[i].innerText = "Please select product's type.";
                errCnt++;
            } else {
                errProductType[i].innerText = "";
            }
            // if( !height[i].value.trim() ) {
            //     errHeight[i].innerText = "Please enter product's height.";
            //     errCnt++;
            // } else {
            //     errHeight[i].innerText = "";
            // }
            // if( !width[i].value.trim() ) {
            //     errWidth[i].innerText = "Please enter product's width.";
            //     errCnt++;
            // } else {
            //     errWidth[i].innerText = "";
            // }
            // if( !length[i].value.trim() ) {
            //     errLength[i].innerText = "Please enter product's length.";
            //     errCnt++;
            // } else {
            //     errLength[i].innerText = "";
            // }
            // if( !weight[i].value.trim() ) {
            //     errWeight[i].innerText = "Please enter product's weight.";
            //     errCnt++;
            // } else {
            //     errWeight[i].innerText = "";
            // }
            if (!quantity[i].value.trim()) {
                errQuantity[i].innerText = "Please enter quantity of product(s).";
                errCnt++;
            } else {
                errQuantity[i].innerText = "";
            }
        }

        var errPickup = pickupValidate();
        console.log('errPickup:' + errPickup);
        if (errPickup > 0) {
            document.getElementById('errPickupModal').textContent = "[1. Pickup / From] has error(s). Please confirm every required filed.";
        }
        var errDeliver = deliverValidate();
        console.log('errDeliver:' + errDeliver);
        if (errDeliver > 0) {
            document.getElementById('errDeliverModal').textContent = "[2. Deliver / To] has error(s). Please confirm every required filed.";
        }

        errCnt = errCnt + errPickup + errDeliver;

        if (errCnt === 0) {
            // Go to next page as no blank
            var pickupModal = bootstrap.Modal.getInstance(document.getElementById('pickupModal'));
            pickupModal.hide();
            var deliverModal = bootstrap.Modal.getInstance(document.getElementById('deliverModal'));
            deliverModal.hide();
            document.getElementById("reqForm").submit();
            var currentModalEl = document.getElementById('AddItemsModal');
            var currentModal = bootstrap.Modal.getInstance();
            currentModal.hide();
            // location.href = "https://trustmoversfreight.spectreum.co.nz/vendor_datanew"
        }
    }

    function selectedOptions(val) {
        var e = e || window.event;
        var elem = e.target || e.srcElement;
        var elemId = elem.id;
        var arryElemId = elemId.split('_');
        elemOptions = arryElemId[0];
        elemId = arryElemId[1];
        console.log('elemId: ' + elemId);
        console.log('elemOptions: ' + elemOptions);

        installation = document.getElementById('installation_' + elemId);
        unwrap = document.getElementById('unwrap_' + elemId);
        fragile = document.getElementById('fragile_' + elemId);
        none = document.getElementById('none_' + elemId);

        if (elemOptions === "none") {
            installation.checked = false;
            unwrap.checked = false;
            fragile.checked = false;
            if (val === "none") {
                none.checked = true;
            }
        } else {
            none.checked = false;
        }
        if (!installation.checked && !unwrap.checked && !fragile.checked) {
            none.checked = true;
        }
    }
</script>

<!-- Duplicate inputs -->
<script type="text/javascript">
    $(function() {
        $('#list').addInputArea({
            maximum: 50
        });
    });
</script>

<!-- Tracking Details -->

<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/public_html/resources/views/vendor/add_orders.blade.php ENDPATH**/ ?>