<?php $__env->startSection('title'); ?> Orders <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?> 
<link href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs5/b-2.2.2/b-html5-2.2.2/sb-1.3.2/datatables.min.css"/>
<style>
    .page-item.active .page-link {
        background-color: #F8931F;
        border-color: #F8931F;
    }
    .top{
        display: flex;
        align-items: center;    
    }
    .btn-secondary, .btn-light{
        background-color: #F8931F;
        border-style: none;
        color: #fff;
    }
    .btn-secondary:hover, .btn-light:hover {
        background-color:#FEAF2F;
        color: #fff;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="product-status mg-b-30">
    <div class="container-fluid">
        <div class="row dataList">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align: left;">
                <h4 class="heading_h4" style="margin-left: 10px;"><i class="fas fa-hotel"></i> Orders</h4>
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                <fieldset id="date-range" class="row dataRow">
                    <div class="col-md-1">
                        <span>Date Range:</span>
                    </div>
                    <div class="col-md-2">
                        <select id="date-type" class="form-control" name="date-type">
                            <option value=''>Select Date Type</option>
                            <option value='order_date'>Order Date</option>
                            <option value='pickup_date'>Pickup Date</option>
                            <option value='delivery_date'>Delivery Date</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <input type="date" name="from-date" placeholder="From" id="from-date" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-1" style="text-align: center;">
                        <span>To</span>
                    </div>
                    <div class="col-md-2">
                        <input type="date" name="to-date" placeholder="To" id="to-date" class="form-control form-control-sm">
                    </div>
                </fieldset>

                <fieldset id="vendor-filter" class="row dataRow">
                    <div class="col-md-1">
                        <span>Vendor:</span>
                    </div>
                    <div class="col-md-2">
                        <select id="vendor-select" class="form-control" name="vendor-select">
                            <option value=''>Select Vendor</option>
                            <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value='<?php echo e($vendor->vendor_id); ?>'><?php echo e($vendor->vendor_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </fieldset>
                
                <table id="orderTable" class="table table-striped table-bordered display" style="width:100%">
                    <thead>
                    <tr>
                        <th>Order #</th>
                        <th>Invoice #</th>
                        <th>Order Date</th>
                        <th>Vendor Name</th>
                        <th>Pickup Address</th>
                        <th>Pickup Date</th>
                        <th>Customer Name</th>
                        <th>Delivery Address</th>
                        <th>Delivery Date</th>
                        <th>Order Status</th>
                        <th>Delivery Notes</th>
                        <th>Estimated Distance</th>
                        <th>Estimated Delivery Charges</th>
                        <th>Additional Charges</th>
                        <th>Additional Charges Notes</th>
                        <th>Total Charges</th>
                        <th>Total Cubic</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                        
    
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
        

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.bootstrap5.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>



<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.11.2/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.10.24/dataRender/datetime.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.11.5/sorting/datetime-moment.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.12.1/sorting/date-eu.js"></script>

<script>
    $(document).ready( function () {
        let table = $('#orderTable').DataTable({
            "processing": true,
            "serverSide": true,
            autoFill: true,
            responsive: true,
            "ajax": {
                url: '<?php echo e(route("api.orders.all")); ?>',
                data: function(data) {
                    data.date_type = $("#date-type").val();
                    data.from_date = $("#from-date").val();
                    data.to_date = $("#to-date").val();
                    data.vendor = $("#vendor-select").val();
                }
            },
            "columns": [
                { 
                    "data": "order_id", 
                    render: function(data) {
                        return "TM" + data
                    }
                },
                {
                    data: "invoice_num"
                },
                { 
                    "data": "created_at",
                    name: "orders.created_at",
                    type: 'num',
                    render: {
                        _: 'display',
                        sort: 'timestamp'
                    },
                    searchable: false  
                },
                { "data": "vendor_name", name: "vendors.vendor_name" },
                { "data": "pickup_address" },
                { 
                    "data": "pickup_date",
                    name: "orders.pickup_date",
                    type: 'num',
                    render: {
                        _: 'display',
                        sort: 'timestamp'
                    },
                    searchable: false 
                },
                { 
                    "data": "receiver_first_name",
                    render: function(data, type, row) {
                        return data + " " + row.receiver_last_name
                    }
                },
                { "data": "receiver_address" },
                { 
                    "data": "delivery_date",
                    name: "orders.delivery_date",
                    type: 'num',
                    render: {
                        _: 'display',
                        sort: 'timestamp'
                    },
                    searchable: false  
                },
                { 
                    "data": "order_status_name",
                    name: "order_statuses.order_status_name",
                    render: function(data, type, row) {
                        let html = `
                                <span class="badge rounded-pill " style="background-color:green">
                                ${ data }
                            </span>`
                        if(row.order_status_id === 1)
                            html = `
                                <span class="badge rounded-pill " style="background-color:red">
                                ${ data }
                            </span>`

                        if(row.order_status_id >= 7)
                            html = `
                                <span class="badge rounded-pill " style="background-color:grey">
                                ${ data }
                            </span>`
                        
                        if(data === null)
                            html = `
                                <span class="badge rounded-pill " style="background-color:grey">
                                Pending Confirmation
                            </span>`

                        return html;
                    } 
                },
                { data: "delivery_note" },
                { 
                    "data": "estimated_distance",
                    render: function(data) {
                        return data + " km";
                    }, 
                },
                { 
                    "data": "estimated_delivery_charge",
                    render: function(data) {
                        return "$ " + data;
                    }, 
                },
                { 
                    "data": "total_additional_charges",
                    name: "total_additional_charges",
                    render: function(data) {
                        let cost = "$ " + data;
                        if(data < 0) {
                            cost = "- $ " + Math.abs(data);
                        } 
                        return cost;
                    },
                    searchable: false,
                },
                { 
                    "data": "additional_charges",
                    render: function(data) {
                        notes = "<ul>";
                        for(let i in data) {
                            notes += `<li style="list-style: initial;">${data[i].remarks}</li>`;
                        }
                        notes += "</ul>";
                        return notes;
                    },
                    searchable: false,
                    sortable: false
                },
                { 
                    "data": "total_charges",
                    name: "total_charges",
                    searchable: false,
                    render: function(data) {
                        let cost = "$ " + data;
                        if(data < 0) {
                            cost = "- $ " + Math.abs(data);
                        } 
                        return cost;
                    }
                },
                { "data": "total_cubic" },
                { 
                    "data": "actions",
                    sortable: false,
                    searchable: false,
                },
                {
                    data: 'receiver_last_name',
                    searchable: true,
                    visible: false
                },
            ],
            "pageLength": 50,
            order: [[1, 'DESC']],
            dom: 
            "<'row top'<'col-sm-3 text-center'B><'col-sm-3'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-3'i><'col-sm-3'l><'col-sm-6'p>>",
            // buttons: [
            //     {
            //         extend: 'collection',
            //         text: 'Export',
            //         buttons: [ 'csv', 'excel', 'pdf' ],
            //     },
            // ],
            buttons: ['csv', 'excel', 'pdf' ],
        });

        $('#date-range').change(function() {
            if($("#date-type").val().length > 0) {
                table.draw();
            }                    
        }); 

        $('#vendor-select').change(function() {
            if($("#vendor-select").val().length > 0) {
                table.draw();
            }                    
        });
    });

    function swalDelete(form_id) {
        Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert order!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, Delete order!',
        customClass: {
            confirmButton: 'btn btn-primary',
            cancelButton: 'btn btn-outline-danger ms-1'
        },
        buttonsStyling: false
        }).then(function(result) {
        if (result.value) {
            $(form_id).submit();

            Swal.fire({
            icon: 'success',
            title: 'Deleted!',
            text: 'Order has been deleted.',
            customClass: {
                confirmButton: 'btn btn-success'
            }
            });

        } else if (result.dismiss === Swal.DismissReason.cancel) {
            Swal.fire({
            title: 'Cancelled',
            text: 'Cancelled Delete :)',
            icon: 'error',
            customClass: {
                confirmButton: 'btn btn-success'
            }
            });
        }
        });
    };
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/public_html/resources/views/admin/orders.blade.php ENDPATH**/ ?>