

<?php $__env->startSection('title'); ?> Order History <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('head-scripts'); ?>

<!--fontawesome-->
<link href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,700,900" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(asset('/wrd_file/tachyons.min.css')); ?>">
<link href="<?php echo e(asset('/wrd_file/css')); ?>" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(asset('/wrd_file/style.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('/wrd_file/orderLogs.css')); ?>">
<link href="<?php echo e(asset('/css1/style.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('/css1/admin.css')); ?>" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.tablesorter/2.31.3/js/jquery.tablesorter.min.js" integrity="sha512-qzgd5cYSZcosqpzpn7zF2ZId8f/8CHmFKZ8j7mU4OUXTNRd5g+ZHBPsgKEwoqxCtdQvExE5LprwwPAgoicguNg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.11.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>
<script src="https://cdn.datatables.net/datetime/1.1.2/js/dataTables.dateTime.min.js"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<div class="product-status mg-b-30">
    <div class="container-fluid">
        <div class="row dataList" style="margin: auto;">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align: left;">
                <div class="product-status-wrap" style="width: 95vw; margin: auto;">
                    <h4 class="heading_h4" style="margin-left: 10px;"><i class="fas fa-hotel"></i> Orders History</h4>
                    <div class="row dataRow">
                        <div class="col cp_iptxt">
                            <button class="btn btn-primary" style="padding: 0.5rem; font-size: small; margin-left: 10px;" data-bs-toggle="modal" data-bs-target="#filterModal">Filter</button>
                        </div>
                    </div>
                    <table id="orderTable" class="table table-striped table-borderless">
                        <thead>
                            <tr>
                                <th>Order #</th>
                                <th>Order Date</th>
                                <th>Invoice #</th>
                                <th>Receiver Name</th>
                                <th>Pickup Address</th>
                                <th>Pickup Date</th>
                                <th>Delivery Address</th>
                                <th>Delivery Date</th>
                                <th>Status</th>
                                <th></th>

                                <!-- <th>Signature</th> -->
                                <!--  <th>Actions</th>-->
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orders_status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orders): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><a class="order" href="<?php echo e(route('vendor.orders.show', $orders)); ?>">TM<?php echo e($orders->order_id); ?></a></td>
                                <td><?php echo e($orders->created_at->format("Y-m-d")); ?></td>
                                <td><?php echo e($orders->invoice_num); ?></td>
                                <td><?php echo e($orders->receiver_first_name); ?> <?php echo e($orders->receiver_last_name); ?></td>
                                <td><?= str_replace('%', ',', $orders->pickup_address) ?></td>
                                <td><?php echo e($orders->pickup_date); ?></td>
                                <td><?= str_replace('%', ',', $orders->receiver_address) ?></td>
                                <td><?php echo e($orders->delivery_date); ?></td>
                                <td>
                                    <?php $__currentLoopData = $orders->orderStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($status->pivot->current): ?>
                                            <?php echo e($status->order_status_name); ?>

                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($orders->orderStatuses->isEmpty()): ?>
                                        Pending Confirmation
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('vendor.orders.print', $orders)); ?>" target="_blank" class="orders icons"><i class="fas fa-print"></i></a>
                                    
                                    
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- TrackYourOrder Modal-->


<!-- Filter Modal -->
<div class="modal fade " id="filterModal" tabindex="-1" aria-labelledby="filterModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="filterModalLabel">Orders Filter</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container">
                    <!-- <div class="row mb-2">
                            <div class="col">
                                Vendor
                                <select class="form-control">
                                    <option>- Select Vendor -</option>
                                    <option>Vendor A</option>
                                    <option>Vendor B</option>
                                    <option>Vendor C</option>
                                    <option>Vendor D</option>
                                </select>
                            </div>
                        </div> -->
                    <div class="row mb-2">
                        <div class="col-3">
                            Start Date
                            <input id="startDate" class="form-control" type="date" placeholder="Start Date" value="">
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-3">
                            End Date
                            <input id="endDate" class="form-control" type="date" placeholder="End Date" value="">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button id="filter-button" type="button" class="btn btn-primary" href="#"><i class="fas fa-sort-amount-down"></i> Filter</button>
                <button id="clear-button" type="button" class="btn btn-danger" href="#"><i class="fas fa-trash-alt"></i> Clear</button>
                <button type="button" class="btn btn-success" href="#"><i class="fas fa-file-download"></i> Download CSV</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fas fa-times-circle"></i> Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Details Modal -->
<div class="modal fade " id="detailsModal" tabindex="-1" aria-labelledby="detailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="detailsModalLabel">Order Details #123</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container">
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Invoice#</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">inv#23234</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Vendor Name</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">Ayaka</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Vendor Address</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">109 Queen Street, CBD, Auckland</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Customer Name</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">Adi</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Customer Address</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">597 Rosebank, Avondale</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Estimated Distance</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">10.4 km</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Pickup Date</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">2021-01-11</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Driver for Pickup</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><span class="badge rounded-pill bg-primary">Mayur</span></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Pickup Driver Mobile</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">012 345 6789</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Driver for Delivery</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><span class="badge rounded-pill bg-primary">Dona</span></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Delivery Driver Mobile</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">098 765 4321</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Estimated Delivery Date Time</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">2021-01-11</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Estimated Delivery Changes</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">-</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Extra Charges</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">0.0</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Total Amount</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">73.45</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Total Cubic</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">4.8</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Cubic Charges</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">0.0</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Add Charges</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">0.0</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Extra Charges Remarks</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">0.0</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Order Date Time</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">2021-01-11 11:23:45</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Stairs/Lift</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">0.0</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Floor</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">0</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Courier Type</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start">Furniture</div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Order Status</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><span class="badge rounded-pill bg-secondary">Pending</span></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Order Delay Time</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Delay Reason</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Pickup Image</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Drop Image</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Signature's</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Remark by Driver</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"></div>
                    </div>
                    <div class="row dataList">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"><label class="dataLabel text-muted">Remark</label></div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-sm-start"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fas fa-times-circle"></i> Close</button>
                <!-- <button type="button" class="btn btn-primary" data-bs-dismiss="modal" data-bs-toggle="modal" href="#detailsEditModal"><i class="fas fa-edit"></i> Edit</button> -->
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('body-scripts'); ?>
<script>
    var startDate, endDate;

    // Custom filtering function which will search data in column four between two values
    $.fn.dataTable.ext.search.push(
        function(settings, data, dataIndex) {
            var min = startDate.val() ? new Date(startDate.val()) : null;
            var max = endDate.val() ? new Date(endDate.val()) : null;
            var date = new Date(data[1]);
            console.log(date);
            if (
                (min === null && max === null) ||
                (min === null && date <= max) ||
                (min <= date && max === null) ||
                (min <= date && date <= max)
            ) {
                return true;
            }
            return false;
        }
    );

    $(document).ready(function() {
        startDate = $('#startDate');
        endDate = $('#endDate');
        // DataTables initialisation
        var orderTable = $('#orderTable').DataTable({
            "language": {
                // "search": "Search",
                searchPlaceholder: "Order #"
            },
            "order": [1, 'desc'],
            "pageLength": 50
        });

        // Refilter the table
        $('#filter-button').on('click', function() {
            orderTable.draw();
        });

        $('#clear-button').on('click', function() {
            startDate.val('');
            endDate.val('');
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('vendor.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/public_html/resources/views/vendor/orders.blade.php ENDPATH**/ ?>