
<?php $__env->startSection('title'); ?> Edit Order <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">

<style>
    tr,
    td,
    th {
        border: 1px solid #000;
    }

    th {
        background-color: #333;
        color: #fff;
        padding: .5rem 4px;
    }

    table th,
    tr,
    td {
        text-align: center;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">

        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="review-tab-pro-inner">
                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php endif; ?>
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="error_msg">
                    <p style="text-align: center; color: red;" id="errMsg"></p>
                </div>
                <div id="myTabContent" class="tab-content custom-product-edit">
                    <form action="<?php echo e(route('admin.orders.update', $order)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo e(csrf_field()); ?>

                        <div class="product-tab-list tab-pane fade active in show" id="description">
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="review-content-section">
                                        <h1><i class="fas fa-user-edit"></i> Edit TM<?php echo e($order->order_id); ?></h1>
                                        <fieldset>
                                            <legend>Customer information</legend>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Customer First Name</label></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><input type="text" class="form-control" name="receiver_first_name" value="<?php echo e($order->receiver_first_name); ?>"></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Customer Last Name</label></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><input type="text" class="form-control" name="receiver_last_name" value="<?php echo e($order->receiver_last_name); ?>"></div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Customer Address</label></div>
                                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                    <input id="receiver_address" type="text" name="receiver_address" class="form-control pac-target-input" value="<?php echo e($order->receiver_address); ?>" placeholder="Enter a location" autocomplete="off">
                                                    <input id="receiver_zip_code" type="hidden" name="receiver_zip_code" value="<?php echo e($order->receiver_zip_code); ?>">
                                                    <input id="receiver_latitude" type="hidden" name="receiver_latitude" value="<?php echo e($order->receiver_latitude); ?>">
                                                    <input id="receiver_longitude" type="hidden" name="receiver_longitude" value="<?php echo e($order->receiver_longitude); ?>">
                                                </div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Customer Phone</label></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="input-group">
                                                        <span class="input-group-text">+64</span>
                                                        <input type="text" class="form-control" name="receiver_phone" value="<?php if( mb_substr($order->receiver_phone, 0, 2) === '64' || mb_substr($order->receiver_phone, 0, 3) === '+64'): ?> <?php echo e(mb_substr($order->receiver_phone, 2)); ?> <?php else: ?> <?php echo e($order->receiver_phone); ?> <?php endif; ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Receiver Email</label></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><input type="text" class="form-control" name="receiver-email" value="<?php echo e($order->receiver_email); ?>"></div>
                                            </div>
                                        </fieldset>
                                        <fieldset>
                                            <legend>Delivery Information</legend>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Pickup Date</label></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><input type="date" class="form-control" name="pickup-date" value="<?php echo e($order->pickup_date); ?>"></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Delivery Date</label></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><input type="date" class="form-control" name="delivery-date" value="<?php echo e($order->delivery_date); ?>"></div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Pickup Address</label></div>
                                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12"><input id="receiver_address" type="text" name="pickup-address" class="form-control pac-target-input" value="<?php echo e($order->pickup_address); ?>" placeholder="Enter a location" autocomplete="off" disabled></div>
                                            </div>

                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Estimated Distance</label></div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <input type="text" id="estimated-distance" class="form-control" name="estimated-distance" value="<?php echo e($order->estimated_distance); ?>">
                                                    <input id="pickup_zip_code" type="hidden" name="pickup_zip_code" value="<?php echo e($order->pickup_zip_code); ?>">
                                                    <input id="pickup_latitude" type="hidden" name="pickup_latitude" value="<?php echo e($order->pickup_latitude); ?>">
                                                    <input id="pickup_longitude" type="hidden" name="pickup_longitude" value="<?php echo e($order->pickup_longitude); ?>">
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Estimated Delivery Charges</label></div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"><input type="text" class="form-control" name="estimated-delivery-charges" value="<?php echo e($order->estimated_delivery_charge); ?>"></div>
                                            </div>

                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Total Cubic</label></div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"><input type="text" name="total-cubic" class="form-control" value="<?php echo e($order->total_cubic); ?>"></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Cubic Charges</label></div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"><input type="text" name="cubic-charges" class="form-control" value="<?php echo e($order->cubic_charges); ?>"></div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Drop Off Access</label></div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <select class="form-control" name="drop-off-access">
                                                        <option value="Ground" <?php if($order->drop_off_access === 'Ground'): echo 'selected'; endif; ?>>Ground</option>
                                                        <option value="Stair" <?php if($order->drop_off_access === 'Stair'): echo 'selected'; endif; ?>>Stair</option>
                                                        <option value="Lift" <?php if($order->drop_off_access === 'Lift'): echo 'selected'; endif; ?>>Lift</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Floor</label></div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"><input type="number" class="form-control" min="0" name="floor" value="<?php echo e($order->floor); ?>"></div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Additional Charge</label></div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <?php 
                                                    $total_additional_charge = 0;
                                                    foreach( $order->additionalCharges as $additional_charge ) {
                                                        $total_additional_charge = $total_additional_charge + $additional_charge->amount;
                                                    }
                                                    ?>
                                                    $ <?php echo e($total_additional_charge); ?>

                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Total Charge</label></div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <?php 
                                                    $total_charge = floatval($order->estimated_delivery_charge) + $total_additional_charge;
                                                    ?>
                                                    $ <?php echo e($total_charge); ?>

                                                </div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Delivery Note</label></div>
                                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                    <textarea class="form-control" id="deliverynote" rows="5" cols="30" placeholder="Delivery Note if any" name="delivery-note"><?php echo e($order->delivery_note); ?></textarea>
                                                </div>
                                            </div>
                                        </fieldset>

                                        <fieldset>
                                            <legend>Packages</legend>
                                            <div class="row">
                                                <table id="orderTable" style="margin: 0px auto;">
                                                    <thead>
                                                        <tr>
                                                            <th>Reference #</th>
                                                            <th>Product Type</th>
                                                            <th>Description</th>
                                                            <th>Quantity</th>
                                                            <th>Length</th>
                                                            <th>Width</th>
                                                            <th>Height</th>
                                                            <th>Total Cubic</th>
                                                            <th>Weight</th>
                                                            <th>Installation</th>
                                                            <th>Unwrap</th>
                                                            <th>Fragile</th>
                                                            <th>Print</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $order->packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($package->reference_id); ?></td>
                                                            <td><?php echo e($package->product_type); ?></td>
                                                            <td><?php echo e($package->product_description); ?></td>
                                                            <td><?php echo e($package->quantity); ?></td>
                                                            <td><?php echo e($package->length); ?> <?php echo e($package->unit); ?></td>
                                                            <td><?php echo e($package->width); ?> <?php echo e($package->unit); ?></td>
                                                            <td><?php echo e($package->height); ?> <?php echo e($package->unit); ?></td>
                                                            <td><?php echo e($package->cubic); ?> ㎥</td>
                                                            <td><?php echo e($package->weight); ?> Kg</td>
                                                            <td>
                                                                <?php if($package->installation === 1): ?>
                                                                <i class="fas fa-check"></i>
                                                                <?php else: ?>
                                                                <i class="fas fa-times"></i>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td>
                                                                <?php if($package->unwrap === 1): ?>
                                                                <i class="fas fa-check"></i>
                                                                <?php else: ?>
                                                                <i class="fas fa-times"></i>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td>
                                                                <?php if($package->fragile === 1): ?>
                                                                <i class="fas fa-check"></i>
                                                                <?php else: ?>
                                                                <i class="fas fa-times"></i>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td>
                                                                <a href="<?php echo e(route('admin.packages.print', $package)); ?>" target="_blank">
                                                                    <i class="fa fa-print" aria-hidden="true"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                        </fieldset>
                                        <br>
                                        <fieldset>
                                            <legend>Driver Tasks</legend>
                                            <div class="row">
                                                <table id="orderTable" style="margin: 0px auto;">
                                                    <thead>
                                                        <tr>
                                                            <th>Task Type</th>
                                                            <th>Driver</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $order->drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($driver->pivot->taskType->task_type_name); ?></td>
                                                            <td><?php echo e($driver->driver_first_name); ?> <?php echo e($driver->driver_last_name); ?></td>
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                        </fieldset>
                                        <br>
                                        <fieldset>
                                            <legend>Additional Charges</legend>
                                            <div id="divChargeInput" class="form-div" style="display: flex; align-items: end;">
                                                <div class="mg-b-pro-edt col-lg-4 col-md-4 col-sm-12 col-xs-12 " style="text-align: left;">
                                                    <input id="charge_id" type="hidden" name="charge-id[]" class="locations form-control" style="display: inline; width: 83%; background-color:#fff; border-width:0; box-shadow: none;" readOnly value="">
                                                    <label for="charge-amount">Amount</label>
                                                    <div class="cp_iptxt" >
                                                        <input type="number" step='any' name="charge-amount[]" id="charge-amount" class="form-control" style="padding-left: 20px !important; " placeholder="0">
                                                        <i class="fas fa-dollar-sign" style="top: 5px;"></i>
                                                    </div>
                                                </div>
                                                <div class="mg-b-pro-edt col-lg-4 col-md-4 col-sm-12 col-xs-12 " style="text-align: left;">
                                                    <label for="charge-remarks">Remarks</label>
                                                    <input type="text" name="charge-remarks[]" id="charge-remarks" class="form-control" placeholder="Enter Remarks">
                                                </div>
                                                <div class="mg-b-pro-edt col-lg-2 col-md-2 col-sm-12 col-xs-12" style="text-align: left;">
                                                    <button id="btnAdd" name="btnAdd" type="button" class="btn btn-info btn-round" onclick="addCharge()"><i class="fas fa-plus"></i></button>
                                                </div>
                                            </div>
                                            <div id="divAddedCharges" class="form-div" style="display: flex; align-items: end;">
                                                <div id="divAddedCharge" class="mg-b-pro-edt col-lg-12 col-md-12 col-sm-12 col-xs-12 " style="text-align: left;">
                                                    
                                                    <?php $__currentLoopData = $order->additionalCharges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $additionalCharge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div id="ChargeSet_<?php echo e($key); ?>" style="display: flex; align-items: center">
                                                        <input id="charge_id_<?php echo e($key); ?>" type="hidden" name="charge-id[]" class="locations form-control" style="display: inline; width: 35%; background-color:#fff; border-width:0; box-shadow: none;" readOnly value="<?php echo e($additionalCharge->additional_charge_id); ?>">
                                                        <input id="charge_amount_<?php echo e($key); ?>" name="charge-amount[]" class="locations form-control" style="display: inline; width: 35%; background-color:#fff; border-width:0; box-shadow: none;" readOnly value="<?php echo e($additionalCharge->amount); ?>">
                                                        <input id="charge_remarks_<?php echo e($key); ?>" name="charge-remarks[]" class="locations form-control" style="display: inline; width: 35%; background-color:#fff; border-width:0; box-shadow: none;" readOnly value="<?php echo e($additionalCharge->remarks); ?>">
                                                        <button id="btnDelete_ChargeSet_<?php echo e($key); ?>" name="btnDelete" type="button"  class="btn btn-danger btn-round" onclick="deleteInputField('ChargeSet', <?php echo e($key); ?>)"><i class="fas fa-times"></i></button>
                                                    </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </fieldset>
                                        <fieldset>
                                            <legend>Order Status</legend>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Order Status</label></div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <?php if($order->currentStatus()): ?>
                                                        <select class="form-control" name="order-status">
                                                            
                                                            <?php $__currentLoopData = $orderStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($orderStatus->order_status_id); ?>" <?php if($order->currentStatus()->order_status_id === $orderStatus->order_status_id): echo 'selected'; endif; ?>><?php echo e($orderStatus->order_status_name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    <?php else: ?>
                                                        <strong>This Order is Currently Pending</strong>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="row mb-2">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"><label class="dataLabel text-muted">Order Status Remarks</label></div>
                                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <?php if($order->currentStatus()): ?>
                                                    <textarea class="form-control" id="order-status-remarks" name="order-status-remarks" rows="5" cols="30" placeholder="Remarks if any"><?php echo e($order->currentStatus()->remarks); ?></textarea>
                                                <?php else: ?>
                                                    <strong>This Order is Currently Pending</strong>
                                                <?php endif; ?>
                                                </div>
                                            </div>
                                        </fieldset>
                                        <fieldset style="margin-bottom: 1rem;">
                                            <legend>Attachments</legend>
                                            <div class="col-12 mb-2">
                                                <div class="card">
                                                    <h5 class="card-header">Attachments</h5>
                                                    <div class="card-body">
                                                        <div class="row">
                                                            <table id="orderTable" style="margin: 0px auto;">
                                                                <thead>
                                                                    <tr class="table-header">
                                                                        <th>DATE</th>
                                                                        <th>FILE NAME</th>
                                                                        <th>REMARKS</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php $__currentLoopData = $order->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <tr class="table-border">
                                                                        <td><?php echo e($image->created_at); ?></td>
                                                                        <td><a href="/storage/<?php echo e($image->image_path); ?>" target="_blank"><?php echo e($image->original_file_name); ?></a></td>
                                                                        <td><?php echo e($image->remarks); ?></td>
                                                                    </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </tbody>
                                                            </table>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="text-center custom-pro-edt-ds">
                                        <button type="submit" class="btn btn-ctl-bt waves-effect waves-light m-r-10" name="event" value="add_boy">Save</button>
                                        <a class="btn btn-ctl-bt waves-effect waves-light m-r-10" name="event" onclick="window.location = `<?php echo e(route('admin.listOrders')); ?>`">Back</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<!-- Google API -->
<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=AIzaSyDVAjuVd5ARnE_xmdbKnlLTw8nyBnihK6Y&libraries=places"></script>

<script>
    
    
    function codeAddress() {
        var address = document.getElementById('receiver_address').value;
        console.log(address);
        geocoder.geocode({
            'address': address
        }, function(results, status) {
            if (status == 'OK') {
                document.getElementById('receiver_latitude').value = results[0].geometry.location.lat();
                document.getElementById('receiver_longitude').value = results[0].geometry.location.lng();
                /*
                for (var i = 0; i < results.address_components.length; i++) {
                    for (var j = 0; j < results.address_components[i].types.length; j++) {
                        if (results.address_components[i].types[j] == "postal_code") {
                            document.getElementById('pickup_zip_code').value = results.address_components[i].long_name;
                            console.log(results.address_components[i].long_name);
                        }
                    }
                }
                */
                $.each(results[0].address_components,function(index,value){
                    if(value.types[0] === "postal_code"){
                        $('#receiver_zip_code').val(value.long_name);
                    }
                });
                console.log(results[0].geometry.location.lat());
                console.log(results[0].geometry.location.lng());
                map.setCenter(results[0].geometry.location);
                var marker = new google.maps.Marker({
                    map: map,
                    position: results[0].geometry.location
                });
            } else {
                alert('Geocode was not successful for the following reason: ' + status);
            }
        });
    }
</script>
<script>
    google.maps.event.addDomListener(window, 'load', initReceiverAddress);
    function haversine_distance(pickup, delivery) {
        var R = 6371.0710; // Radius of the Earth in meters
        var rlat1 = pickup.position.lat() * (Math.PI / 180);
        // Convert degrees to radians
        var rlat2 = delivery.position.lat() * (Math.PI / 180);
        // Convert degrees to radians
        var difflat = rlat2 - rlat1; // Radian difference (latitudes)
        var difflon = (delivery.position.lng() - pickup.position.lng()) *
            (Math.PI / 180); // Radian difference (longitudes)

        var d = 2 * R *
            Math.asin(Math.sqrt(Math.sin(difflat / 2) * Math.sin(difflat / 2) +
                Math.cos(rlat1) * Math.cos(rlat2) *
                Math.sin(difflon / 2) * Math.sin(difflon / 2)));
        return d;
    }

    function initReceiverAddress() {
        var input = document.getElementById('receiver_address');
        // var autocomplete = new google.maps.places.Autocomplete(input);

        var options = {
            componentRestrictions: {
                country: "nz"
            }
        };
        var autocomplete = new google.maps.places.Autocomplete(input, options);

        autocomplete.addListener('place_changed', function() {
            var place = autocomplete.getPlace();
            document.getElementById('receiver_latitude').value = place.geometry['location'].lat();
            document.getElementById('receiver_longitude').value = place.geometry['location'].lng();
            var deliveryLat = place.geometry['location'].lat();
            var deliveryLng = place.geometry['location'].lng();
            for (var i = 0; i < place.address_components.length; i++) {
                    for (var j = 0; j < place.address_components[i].types.length; j++) {
                        if (place.address_components[i].types[j] == "postal_code") {
                            document.getElementById('receiver_zip_code').value = place.address_components[i].long_name;
                        }
                    }
                }

            const deliveryLatLng = {
                lat: deliveryLat,
                lng: deliveryLng
            };

            let pickupLat = parseFloat(document.getElementById('pickup_latitude').value);
            let pickupLng = parseFloat(document.getElementById('pickup_longitude').value);

            
            const pickupLatLng = {
                lat: pickupLat,
                lng: pickupLng
            };
            pickup = new google.maps.Marker({
                position: pickupLatLng,
                title: "Pickup Address",
                icon: "https://maps.google.com/mapfiles/kml/paddle/P.png"
            });
            console.log(pickup);
            delivery = new google.maps.Marker({
                position: deliveryLatLng,
                title: "Delivery Address",
                icon: "https://maps.google.com/mapfiles/kml/paddle/D.png"
            });
            

            //var line = new google.maps.Polyline({path: [pickupLatLng, deliveryLatLng], map: map});

            // Calculate and display the distance between markers
            var distance = haversine_distance(pickup, delivery);
            console.log("Distance between markers: " + distance.toFixed(2) + " km.");

            //   document.getElementById('estimated_km').val(distance.toFixed(2));
            $("#estimated-distance").val(distance.toFixed(2));
        });
    }
</script>

<script>
    function addCharge() {
        var inputAmount = document.getElementById('charge-amount').value;
        var inputRemarks = document.getElementById('charge-remarks').value;
        if (inputAmount == 0 || inputAmount == null && inputRemarks == '') {
            return;
        }

        var divAddedLocation = document.getElementById('divAddedCharge');
        var i = document.querySelectorAll('[name="charge-amount[]"]').length + 1;

        // var DeleteBtnCode = ;
        /*
        var LocationCode =
            '<div id= LocationSet_' + i + '" style="display: flex; align-items: center">' +
            '<input id="location_' + i + '" name="locations[]" ' +
            'class="locations form-control" style="display: inline; width: 83%; background-color:#fff; border-width:0; box-shadow: none;" readOnly ' +
            'value="' + inputAddress + '">' +
            '<button id="btnDelete_LocationSet_' + i + '" name="btnRemove" type="button" style="margin-left: 1.9rem;" ' +
            'class="btn btn-danger btn-round" onclick="deleteInputField(\'LocationSet\',' + i + ')"><i class="fas fa-times"></i></button></div>';
        */

        let chargeHTML = `
        <div id= "ChargeSet_${i}" style="display: flex; align-items: center">
            <input id="charge_id_${i}" name="charge-id[]" type="hidden" class="locations form-control" style="display: inline; background-color:#fff; border-width:0; box-shadow: none;" readOnly value="">
            <input id="charge_amount_${i}" name="charge-amount[]" class="locations form-control" style="display: inline; width: 35%; background-color:#fff; border-width:0; box-shadow: none;" readOnly value="${inputAmount}">
            <input id="charge_remarks_${i}" name="charge-remarks[]" class="locations form-control" style="display: inline; width: 35%; background-color:#fff; border-width:0; box-shadow: none;" readOnly value="${inputRemarks}">
            <button id="btnDelete_ChargeSet_${i}" name="btnDelete" type="button" style="margin-left: 1.9rem;" class="btn btn-danger btn-round" onclick="deleteInputField('ChargeSet', ${i})"><i class="fas fa-times"></i></button>
        </div>
        `
        divAddedLocation.insertAdjacentHTML('afterbegin', chargeHTML);

        document.getElementById('charge-amount').value = "";
        document.getElementById('charge-remarks').value = "";
    }

    function deleteInputField(target, i) {
        let chargeID = document.getElementById(`charge_id_${i}`).value;
        if(chargeID != null && chargeID != "") {
            window.location.assign("<?php echo e(url('/admin/orders/charge/delete')); ?>/" + chargeID);
        }
        document.getElementById(target + '_' + i).remove();
        
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/public_html/resources/views/admin/editOrders.blade.php ENDPATH**/ ?>