

<?php $__env->startSection('title'); ?> Signature <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<style>
canvas {
  border: 2px solid #000;
  width: 100%;
  height: 50%;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('head-scripts'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-12 ">
            <div class="card">
                <div class="card-header">
                    <h5>Signature</h5>
                </div>
                <div class="card-body">
                     <?php if($message = Session::get('success')): ?>
                         <div class="alert alert-success  alert-dismissible">
                             <button type="button" class="close" data-dismiss="alert">X</button>  
                             <strong><?php echo e($message); ?></strong>
                         </div>
                     <?php endif; ?>
                     <form id="sigForm" method="POST" action="<?php echo e(route('app.signature.upload', $task_id)); ?>" enctype="multipart/form-data">
                         <?php echo csrf_field(); ?>
                         <div class="col-md-12">
                            <label class="" for="">Signature:</label>
                            <br/>

                            <canvas id="sigCanvas"></canvas>
                            <div style="padding:10px">
                                <button type="button" class="btn btn-secondary w-100" id="clear">Clear</button>
                            </div>
                            <div style="padding:10px">
                                <button type="button" class="btn btnAddFile w-100" id="save" value="1">Save Signature</button>
                            </div>
                            <div id="img-box"><img id="sigImg" name="sigImg"></div>
                            <input id="sigFile" name="sigFile" type="file">

                             <br/>
                             <textarea id="signature64" name="signed" style="display: none"></textarea>
                         </div>
                         <br/>
                     </form>
                </div>
            </div>
        </div>
    </div>
 </div>

    <?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
    <script type="text/javascript">
    var canvas = document.getElementById('sigCanvas');
    
    // Adjust canvas coordinate space taking into account pixel ratio,
    // to make it look crisp on mobile devices.
    // This also causes canvas to be cleared.
    
    function resizeCanvas() {
        // When zoomed out to less than 100%, for some very strange reason,
        // some browsers report devicePixelRatio as less than 1
        // and only part of the canvas is cleared then.
        var ratio =  Math.max(window.devicePixelRatio || 1, 1);
        canvas.width = canvas.offsetWidth * ratio;
        canvas.height = canvas.offsetHeight * ratio;
        canvas.getContext("2d").scale(ratio, ratio);
    }

    window.onresize = resizeCanvas;
    resizeCanvas();
    
    let signaturePad = new SignaturePad(canvas);

    document.getElementById('clear').addEventListener('click', function () {
        signaturePad.clear();
    });
    
    document.getElementById('save').addEventListener('click', function () {
        if (signaturePad.isEmpty()) {
            return alert("Please provide a signature first.");
        }
        
        let png = signaturePad.toDataURL('image/png');
        var blobdata = dataURLtoBlob(png.split(',')[1]);

        //Example var file = dataURLtoBlob(canvas.toDataURL());
        function dataURLtoBlob(dataURL) {
            // Decode the dataURL   
            var binary = atob(dataURL);
            // Create 8-bit unsigned array
            var array = [];
            for (var i = 0; i < binary.length; i++) {
                array.push(binary.charCodeAt(i));
            }
            // Return our Blob object
            return new Blob([new Uint8Array(array)], { type: 'image/png' });
        }
        let sigImg = document.getElementById("sigImg");
        sigImg.src = png;
        document.getElementById("sigFile").drawImage = png;
        let csrf_token = document.getElementsByName("_token")[0].value;
        let request = new XMLHttpRequest();
        request.open("POST", "<?php echo e(route('app.signature.upload', $task_id)); ?>", true);
        let data = new FormData();
        data.append("image", blobdata, "Signature.png");
        request.setRequestHeader('X-CSRF-Token', csrf_token);
        request.onreadystatechange = function() {
            if (request.readyState === XMLHttpRequest.DONE && this.status === 200) {
                // console.log(request.responseText);
            }
        }
        request.send(data);
        request.onreadystatechange = function() {
            if (request.readyState == 4 && request.status == 200) { // when completed we can move away
                window.location.href = "<?php echo e(route('driver.task.details', $task_id)); ?>";
            }
        };        
    });
    
    </script>

    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/w84938540/trustmoversfreight.com/resources/views/app/signature.blade.php ENDPATH**/ ?>